#ifndef QCAP_H
#define QCAP_H

#ifdef BUILD_QCAP_DLL

#define QCAP_EXT_API __declspec(dllexport) 

#else 

#define QCAP_EXT_API __declspec(dllimport) 
#endif

#ifdef _QCAP_VB_EXPORT

#define QCAP_EXPORT __stdcall

#else // _QCAP_VB_EXPORT

#define QCAP_EXPORT __cdecl

#endif // _QCAP_VB_EXPORT

// LABVIEW 2010/2012 SUPPORT
// 
#ifdef _QCAP_LABVIEW_IMPORT

#define QCAP_EXT_API __declspec(dllimport)

#define QCAP_EXPORT __cdecl

typedef void VOID;

typedef void * PVOID;
 
typedef unsigned int UINT;

typedef unsigned long ULONG;

typedef unsigned long DWORD;

typedef unsigned long long ULONGLONG;

typedef char CHAR;

typedef unsigned char BYTE;

#endif // _QCAP_LABVIEW_IMPORT

typedef unsigned short * WSTRING;

// RESULT OF FUNCTION
//
typedef enum {

	QCAP_RS_SUCCESSFUL								= 0x00000000,

	QCAP_RS_ERROR_GENERAL							= 0x00000001,

	QCAP_RS_ERROR_OUT_OF_MEMORY						= 0x00000002,

	QCAP_RS_ERROR_OUT_OF_RESOURCE					= 0x00000003,

	QCAP_RS_ERROR_INVALID_DEVICE					= 0x00000004,

	QCAP_RS_ERROR_INVALID_PARAMETER					= 0x00000005,

	QCAP_RS_ERROR_NON_SUPPORT						= 0x00000006,

	QCAP_RS_ERROR_TIMEOUT							= 0x00000007,

	QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT			= 0x00000008,

	QCAP_RS_ERROR_NO_SIGNAL_DETECTED				= 0x00000009,

	QCAP_RS_ERROR_NEED_MORE_DATA					= 0x0000000A,

	QCAP_RS_ERROR_CONNECT_FAIL						= 0x0000000B,

	QCAP_RS_ERROR_FILE_ACCESS_FAIL					= 0x0000000C,

	QCAP_RS_ERROR_NETWORK_ACCESS_FAIL				= 0x0000000D,

	QCAP_RS_ERROR_FILE_IS_BOX_MOVED					= 0x0000000E,

	QCAP_RS_ERROR_FRAME_IS_COPIED					= 0x0000000F,

	QCAP_RS_ERROR_VIDEO_ENCODER_ACCESS_FAIL			= 0x00000010,

	QCAP_RS_ERROR_AUDIO_ENCODER_ACCESS_FAIL			= 0x00000011,

	QCAP_RS_ERROR_NETWORK_CONNECT_UNKNOWN_FAIL		= 0x80000000,

	QCAP_RS_ERROR_NETWORK_CONNECT_URL_FAIL			= 0x80000001,

	QCAP_RS_ERROR_NETWORK_CONNECT_PASSWORD_FAIL		= 0x80000002,

	QCAP_RS_ERROR_NETWORK_CONNECT_SESSION_NAME_FAIL = 0x80000003,

} QRESULT;

// RETURN OF CALLBACK
//
typedef enum {

	QCAP_RT_OK					= 0x00000000,
	
	QCAP_RT_FAIL				= 0x00000001,

	QCAP_RT_SKIP_RECORD_NUM_00	= 0x00010002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_01	= 0x00020002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_02	= 0x00040002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_03	= 0x00080002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_DISPLAY		= 0x00000004, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK / 
											  //
											  //		  PF_VIDEO_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_BROADCAST_CLIENT_CALLBACK / 
											  //
											  //		  PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK /
											  //
											  //		  PF_VIDEO_DECODER_FILE_CALLBACK / PF_AUDIO_DECODER_FILE_CALLBACK
											  
	QCAP_RT_SKIP_CLONE_DISPLAY	= 0x00000008, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_00	= 0x01000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_01	= 0x02000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_02	= 0x04000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_03	= 0x08000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

} QRETURN;

// DEVICE ENUMERATION TYPE
//
enum {

	QCAP_ENUM_TYPE_DEVICE_NAME		= 0,

	QCAP_ENUM_TYPE_SERIAL_NUMBER	= 1,
};

// INPUT VIDEO SOURCE
//
enum {

	QCAP_INPUT_TYPE_COMPOSITE	 = 0,

	QCAP_INPUT_TYPE_SVIDEO		 = 1,

	QCAP_INPUT_TYPE_HDMI		 = 2,

	QCAP_INPUT_TYPE_DVI_D		 = 3,

	QCAP_INPUT_TYPE_COMPONENTS	 = 4,

	QCAP_INPUT_TYPE_YCBCR		 = 4,

	QCAP_INPUT_TYPE_DVI_A		 = 5,

	QCAP_INPUT_TYPE_RGB			 = 5,

	QCAP_INPUT_TYPE_VGA			 = 5,

	QCAP_INPUT_TYPE_SDI			 = 6,

	QCAP_INPUT_TYPE_DISPLAY_PORT = 8,

	QCAP_INPUT_TYPE_AUTO		 = 7,
};

// INPUT AUDIO SOURCE
//
enum {	

	QCAP_INPUT_TYPE_EMBEDDED_AUDIO			= 0,

	QCAP_INPUT_TYPE_LINE_IN					= 1,

	QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE	= 2,

	QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN		= 3,
};

// VIDEO STANDARD TYPE
//
enum {	

	QCAP_STANDARD_TYPE_NTSC_M		= 0x00000001,

	QCAP_STANDARD_TYPE_NTSC_M_J		= 0x00000002,

	QCAP_STANDARD_TYPE_NTSC_433		= 0x00000004,

	QCAP_STANDARD_TYPE_PAL_M		= 0x00000200,

	QCAP_STANDARD_TYPE_PAL_60		= 0x00000800,

	QCAP_STANDARD_TYPE_PAL_B		= 0x00000010,

	QCAP_STANDARD_TYPE_PAL_D		= 0x00000020,

	QCAP_STANDARD_TYPE_PAL_G		= 0x00000040,

	QCAP_STANDARD_TYPE_PAL_H		= 0x00000080,

	QCAP_STANDARD_TYPE_PAL_I		= 0x00000100,

	QCAP_STANDARD_TYPE_PAL_N		= 0x00000400,

	QCAP_STANDARD_TYPE_PAL_N_COMBO	= 0x00100000,

	QCAP_STANDARD_TYPE_AUTO			= 0x80000000, // DEFAULT, [P.S. SC310N8/N16            (CX2581 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC290N4/SC390N4/N8/N16 (AH8400 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC2B0N4/SC3B0N4/N8/N16 (TW5864 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3A0N4/N8/N16         (FH8735 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3C0N4/N8/N16         (MZ0380 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
};

// VIDEO DEINTERLACE TYPE
//
enum {	

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING			  = 0x00000000, // DEFAULT

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE	  = 0x00000001,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE	  = 0x00000002,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BOB				  = 0x00000003,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_RGB_REPACK = 0x00000010, // DEVELOPING ...
};

// COLORRANGE TYPE
//
enum {

	QCAP_COLORRANGE_TYPE_FULL		        = 0, //  0 ~ 255 (ITU BT.709)

	QCAP_COLORRANGE_TYPE_LIMIT		        = 1, // 16 ~ 235 (ITU BT.709)

	QCAP_COLORRANGE_TYPE_FULL_BGR32	        = 2, //  0 ~ 255 (ITU BT.709) (RENDERER @ RGB32) 

	QCAP_COLORRANGE_TYPE_LIMIT_BGR32        = 3, // 16 ~ 235 (ITU BT.709) (RENDERER @ RGB32) 

	QCAP_COLORRANGE_TYPE_LIMIT_ITU601       = 5, // 16 ~ 235 (ITU BT.601)

	QCAP_COLORRANGE_TYPE_LIMIT_ITU601_BGR32 = 7, // 16 ~ 235 (ITU BT.601) (RENDERER @ RGB32)
};

// COLORSPACE TYPE
//
enum {

	QCAP_COLORSPACE_TYEP_RGB24	= 0,		  //   0xBBGGRR -> R0 G0 B0 R1 G1 B1 R2 G2 B2 ... >>

	QCAP_COLORSPACE_TYEP_BGR24	= 1,		  //   0xRRGGBB -> B0 G0 R0 B1 G1 R1 B2 G2 R2 ... >>

	QCAP_COLORSPACE_TYEP_ARGB32	= 2,		  // 0xAABBGGRR -> R0 G0 B0 A0 R1 G1 B1 A1 R2 G2 B2 A2 ... >>

	QCAP_COLORSPACE_TYEP_ABGR32	= 3,		  // 0xAARRGGBB -> B0 G0 R0 A0 B1 G1 R1 A1 B2 G2 R2 A2 ... >>

	QCAP_COLORSPACE_TYEP_YUY2	= 0x32595559, // 0x32595559 -> MAKEFOURCC('Y', 'U', 'Y', '2')

	QCAP_COLORSPACE_TYEP_UYVY	= 0x59565955, // 0x59565955 -> MAKEFOURCC('U', 'Y', 'V', 'Y')

	QCAP_COLORSPACE_TYEP_YV12	= 0x32315659, // 0x32315659 -> MAKEFOURCC('Y', 'V', '1', '2') (Y V U)

	QCAP_COLORSPACE_TYEP_I420	= 0x30323449, // 0x30323449 -> MAKEFOURCC('I', '4', '2', '0') -> Y U V

	QCAP_COLORSPACE_TYEP_Y800	= 0x30303859, // 0x30303859 -> MAKEFOURCC('Y', '8', '0', '0') -> Y

	QCAP_COLORSPACE_TYEP_MJPG	= 0x47504A4D, // 0x47504A4D -> MAKEFOURCC('M', 'J', 'P', 'G')

	QCAP_COLORSPACE_TYEP_H264	= 0x34363248, // 0x34363248 -> MAKEFOURCC('H', '2', '6', '4')

	QCAP_COLORSPACE_TYEP_H265	= 0x35363248, // 0x34363248 -> MAKEFOURCC('H', '2', '6', '5')
};

// ENCODER TYPE (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_TYPE_SOFTWARE			= 0,

	QCAP_ENCODER_TYPE_HARDWARE			= 1, // IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590 & SC5A0 & SC5C0

	QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK	= 2,

	QCAP_ENCODER_TYPE_AMD_VCE			= 3,

	QCAP_ENCODER_TYPE_NVIDIA_CUDA		= 4,

	QCAP_ENCODER_TYPE_NVIDIA_NVENC		= 5,
};

// ENCODER VIDEO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_MPEG2		=  1,

	QCAP_ENCODER_FORMAT_H264		=  0,

	QCAP_ENCODER_FORMAT_H264_3D		=  2, // H264 MVC (STEREOSCOPIC 3D)

	QCAP_ENCODER_FORMAT_H264_VC		=  3, // H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_ENCODER_FORMAT_RAW			=  4,

	QCAP_ENCODER_FORMAT_RAW_NATIVE	=  4,

	QCAP_ENCODER_FORMAT_H265		=  5,

	QCAP_ENCODER_FORMAT_RAW_YUY2	= 20,

	QCAP_ENCODER_FORMAT_RAW_UYVY	= 21, // DEVELOPING ...

	QCAP_ENCODER_FORMAT_RAW_YV12	= 22,

	QCAP_ENCODER_FORMAT_RAW_I420	= 23, // DEVELOPING ...

	QCAP_ENCODER_FORMAT_RAW_Y800	= 24,
};

// ENCODER AUDIO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_PCM			= 0,

	QCAP_ENCODER_FORMAT_AAC			= 1,

	QCAP_ENCODER_FORMAT_AAC_RAW		= 1,

	QCAP_ENCODER_FORMAT_AAC_ADTS	= 2,

	QCAP_ENCODER_FORMAT_MP2			= 4, // MPEG AUDIO LAYER 2

	QCAP_ENCODER_FORMAT_MP3			= 5, // MPEG AUDIO LAYER 3

	QCAP_ENCODER_FORMAT_OPUS		= 6,

	QCAP_ENCODER_FORMAT_AC3			= 7,
};

// RECORD PROFILE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_PROFILE_BASELINE	         = 0, // DEFAULT

	QCAP_RECORD_PROFILE_MAIN		         = 1,

	QCAP_RECORD_PROFILE_HIGH		         = 2,

	QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE = 3, // ONLY FOR QCAP_ENCODER_FORMAT_H264_VC

	QCAP_RECORD_PROFILE_CONSTRAINED_HIGH     = 4, // ONLY FOR QCAP_ENCODER_FORMAT_H264_VC
};

// RECORD LEVEL (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_LEVEL_1		= 10,

	QCAP_RECORD_LEVEL_1B	=  9,

	QCAP_RECORD_LEVEL_11	= 11,

	QCAP_RECORD_LEVEL_12	= 12,

	QCAP_RECORD_LEVEL_13	= 13,

	QCAP_RECORD_LEVEL_2		= 20,

	QCAP_RECORD_LEVEL_21	= 21,

	QCAP_RECORD_LEVEL_22	= 22,

	QCAP_RECORD_LEVEL_3		= 30,

	QCAP_RECORD_LEVEL_31	= 31,

	QCAP_RECORD_LEVEL_32	= 32,

	QCAP_RECORD_LEVEL_4		= 40,

	QCAP_RECORD_LEVEL_41	= 41, // DEFAULT

	QCAP_RECORD_LEVEL_42	= 42,

	QCAP_RECORD_LEVEL_50	= 50,

	QCAP_RECORD_LEVEL_51	= 51,

	QCAP_RECORD_LEVEL_52	= 52,

	QCAP_RECORD_LEVEL_60	= 60,

	QCAP_RECORD_LEVEL_61	= 61,

	QCAP_RECORD_LEVEL_62	= 62,
};

// RECORD ENTROPY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_ENTROPY_CAVLC	= 0, // DEFAULT

	QCAP_RECORD_ENTROPY_CABAC	= 1,
};

// RECORD COMPLEXITY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_COMPLEXITY_0	= 0, // BEST SPEED, DEFAULT

	QCAP_RECORD_COMPLEXITY_1	= 1,

	QCAP_RECORD_COMPLEXITY_2	= 2,

	QCAP_RECORD_COMPLEXITY_3	= 3,

	QCAP_RECORD_COMPLEXITY_4	= 4,

	QCAP_RECORD_COMPLEXITY_5	= 5,

	QCAP_RECORD_COMPLEXITY_6	= 6, // BEST QUALITY
};

// RECORD MODE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_MODE_VBR		= 0, 

	QCAP_RECORD_MODE_CBR		= 1, 

	QCAP_RECORD_MODE_ABR		= 2, 

	QCAP_RECORD_MODE_CQP		= 3, // DEVELOPING ...

	QCAP_RECORD_MODE_LOSSLESS	= 4, 
};

// DOWNSCALE MODE (RECORD PROPERTY)
// 
enum {

	QCAP_DOWNSCALE_MODE_OFF	= 0, // (1920, 1080) * (1 / 1) = (1920, 1080)

	QCAP_DOWNSCALE_MODE_2_3	= 1, // (1920, 1080) * (2 / 3) = (1280,  720)

	QCAP_DOWNSCALE_MODE_1_2	= 2, // (1920, 1080) * (1 / 2) = ( 960,  540)

	QCAP_DOWNSCALE_MODE_1_4	= 3, // (1920, 1080) * (1 / 4) = ( 480,  270)
};

// RECORD FLAG (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_FLAG_FULL						= 0x00000007,

	QCAP_RECORD_FLAG_FILE						= 0x00000001,

	QCAP_RECORD_FLAG_ENCODE						= 0x00000002,

	QCAP_RECORD_FLAG_DISPLAY					= 0x00000004,

	QCAP_RECORD_FLAG_DECODE						= 0x00000008,

	QCAP_RECORD_FLAG_VIDEO_ONLY					= 0x00000010,

	QCAP_RECORD_FLAG_AUDIO_ONLY					= 0x00000020,

	QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= 0x00000040,

	QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= 0x00000080,

	QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED		= 0x00000100,

	QCAP_RECORD_FLAG_SYNCHRONIZED_RECORD		= 0x00000200, // START BY QCAP_RESUME_RECORD

	QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER		= 0x00000400, // ONLY FOR QCAP_SET_VIDEO_*_UNCOMPRESSION_BUFFER_*

	QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER		= 0x00000800, // ONLY FOR QCAP_SET_AUDIO_*_UNCOMPRESSION_BUFFER_*
};

// BROADCAST FLAG (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_FLAG_FULL						= 0x00000007,

	QCAP_BROADCAST_FLAG_NETWORK						= 0x00000001,

	QCAP_BROADCAST_FLAG_ENCODE						= 0x00000002,

	QCAP_BROADCAST_FLAG_DISPLAY						= 0x00000004,

	QCAP_BROADCAST_FLAG_DECODE						= 0x00000008,

	QCAP_BROADCAST_FLAG_VIDEO_ONLY					= 0x00000010,
	
	QCAP_BROADCAST_FLAG_AUDIO_ONLY					= 0x00000020,

	QCAP_BROADCAST_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= 0x00000040,

	QCAP_BROADCAST_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= 0x00000080,

	QCAP_BROADCAST_FLAG_VIDEO_USE_MEDIA_TIMER		= 0x00000400, // ONLY FOR QCAP_SET_VIDEO_*_UNCOMPRESSION_BUFFER_*

	QCAP_BROADCAST_FLAG_AUDIO_USE_MEDIA_TIMER		= 0x00000800, // ONLY FOR QCAP_SET_AUDIO_*_UNCOMPRESSION_BUFFER_*
};

// BROADCAST PROTOCOL (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_PROTOCOL_UDP	 = 0x00000000,

	QCAP_BROADCAST_PROTOCOL_TCP	 = 0x00000001, // BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

	QCAP_BROADCAST_PROTOCOL_HTTP = 0x00000002,
};

// OSD FONT STYLE (OSD PROPERTY)
//
enum {

    QCAP_FONT_STYLE_REGULAR     = 0x00000000,
    
	QCAP_FONT_STYLE_BOLD        = 0x00000001,
    
	QCAP_FONT_STYLE_ITALIC      = 0x00000002,
    
	QCAP_FONT_STYLE_BOLDITALIC  = 0x00000003,
    
	QCAP_FONT_STYLE_UNDERLINE   = 0x00000004,
    
	QCAP_FONT_STYLE_STRIKEOUT   = 0x00000008,
};

// OSD STRING ALIGNMENT (OSD PROPERTY)
//
enum {

	QCAP_STRING_ALIGNMENT_STYLE_LEFT    = 0x00000000,

    QCAP_STRING_ALIGNMENT_STYLE_NEAR    = 0x00000000,
    
	QCAP_STRING_ALIGNMENT_STYLE_CENTER  = 0x00000001,
    
	QCAP_STRING_ALIGNMENT_STYLE_RIGHT   = 0x00000002,
    
	QCAP_STRING_ALIGNMENT_STYLE_FAR		= 0x00000002,
};

// OSD SEQUENCE STYLE (OSD PROPERTY)
//
enum {

	//  GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> BEFORE_ENCODE -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE RECORDING: FOREMOST -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE STREAMING: FOREMOST -> STREAMING (ENCODING) -> AFTERMOST
	//
	//  VIRTUAL CAMERA: FOREMOST -> AFTERMOST -> SHARING
	//
	//   FILE PLAYBACK: PLAYBACK (DECODING) -> FOREMOST -> DECODER CALLBACK -> AFTERMOST
	//
	QCAP_SEQUENCE_STYLE_FOREMOST		= 0x00000000,

    QCAP_SEQUENCE_STYLE_BEFORE_ENCODE	= 0x00000001, // IT IS ONLY USED FOR GENERAL DEVICE
    
	QCAP_SEQUENCE_STYLE_AFTERMOST		= 0x00000002,
};

// BUFFER SCALE STYLE (BUFFER PROPERTY)
//
enum {

	QCAP_SCALE_STYLE_STRETCH	= 0x00000000,

    QCAP_SCALE_STYLE_FIT		= 0x00000001,
    
	QCAP_SCALE_STYLE_FILL		= 0x00000002,
};

// DECODER TYPE (PLAYBACK PROPERTY)
//
enum {

	QCAP_DECODER_TYPE_SOFTWARE			= 0,

	QCAP_DECODER_TYPE_HARDWARE			= 1, // DEVELOPING ...

	QCAP_DECODER_TYPE_INTEL_MEDIA_SDK	= 2,

	QCAP_DECODER_TYPE_AMD_UVD			= 3, // DEVELOPING ...

	QCAP_DECODER_TYPE_AMD_VCE			= 3, // == QCAP_DECODER_TYPE_AMD_UVD

	QCAP_DECODER_TYPE_NVIDIA_CUDA		= 4,

	QCAP_DECODER_TYPE_NVIDIA_NVDEC		= 5,

	QCAP_DECODER_TYPE_NVIDIA_NVENC		= 5, // == QCAP_DECODER_TYPE_NVIDIA_NVDEC
};

// DECODER VIDEO FORMAT (PLAYBACK PROPERTY)
//
enum {

	QCAP_DECODER_FORMAT_MPEG2		=  1,

	QCAP_DECODER_FORMAT_H264		=  0,

	QCAP_DECODER_FORMAT_H264_3D		=  2, // H264 MVC (STEREOSCOPIC 3D)

	QCAP_DECODER_FORMAT_H264_VC		=  3, // H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_DECODER_FORMAT_RAW			=  4,

	QCAP_DECODER_FORMAT_H265		=  5,
};

// 3D STEREO BUFFER TYPE
//
enum {

	QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE		= 0,

	QCAP_3D_STEREO_BUFFER_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_BUFFER_LINE_BY_LINE		= 2,
};

// 3D STEREO DISPLAY MODE
//
enum {

	QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE	= 0,

	QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE	= 2,

	QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY		= 3,

	QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY		= 4,
};

// FILE TIMEUNIT
//
enum {

	QCAP_FILE_TIMEUNIT_TIME		= 0,

	QCAP_FILE_TIMEUNIT_FRAME	= 1,
};

// SERIAL PORT PARITY CHECK (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_PARITY_CHECK_NONE	= 0x00000000,

	QCAP_SERIAL_PORT_PARITY_CHECK_ODD	= 0x00000001,

	QCAP_SERIAL_PORT_PARITY_CHECK_EVEN	= 0x00000002,

	QCAP_SERIAL_PORT_PARITY_CHECK_MARK	= 0x00000003,		

	QCAP_SERIAL_PORT_PARITY_CHECK_SPACE	= 0x00000004,
};

// SERIAL PORT FLOW CONTROL (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_FLOW_CONTROL_NONE		= 0x00000000,

	QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_RTS	= 0x00000001,

	QCAP_SERIAL_PORT_FLOW_CONTROL_CTS_DTR	= 0x00000002,

	QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_RTS	= 0x00000003,

	QCAP_SERIAL_PORT_FLOW_CONTROL_DSR_DTR	= 0x00000004,

	QCAP_SERIAL_PORT_FLOW_CONTROL_XON_XOFF	= 0x00000005,
};

// SERIAL PORT STOP BITS (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_STOP_BITS_ONE				= 0x00000000,

	QCAP_SERIAL_PORT_STOP_BITS_ONE_POINT_FIVE	= 0x00000001,

	QCAP_SERIAL_PORT_STOP_BITS_TWO				= 0x00000002,
};

// SERIAL PORT SIGNAL TYPE (SERIAL PORT PROPERTY)
//
enum {

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_DTR		= 0x00000000, // CLEAR THE DTR (DATA-TERMINAL-READY) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_RTS		= 0x00000001, // CLEAR THE RTS (REQUEST-TO-SEND) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_DTR		= 0x00000002, // SEND THE DTR (DATA-TERMINAL-READY) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_RTS		= 0x00000003, // SEND THE RTS (REQUEST-TO-SEND) SIGNAL

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XOFF		= 0x00000004, // CAUSE TRANSMISSION TO ACT AS IF AN XOFF CHARACTER HAS BEEN RECEIVED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_XON		= 0x00000005, // CAUSE TRANSMISSION TO ACT AS IF AN XON CHARACTER HAS BEEN RECEIVED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_SET_BREAK		= 0x00000006, // SUSPEND CHARACTER TRANSMISSION FOR A SPECIFIED COMMUNICATIONS DEVICE AND PLACES THE TRANSMISSION LINE IN A BREAK STATE UNTIL THE CLEARCOMMBREAK FUNCTION IS CALLED

	QCAP_SERIAL_PORT_SIGNAL_TYPE_CLEAR_BREAK	= 0x00000007, // RESTORE CHARACTER TRANSMISSION FOR A SPECIFIED COMMUNICATIONS DEVICE AND PLACES THE TRANSMISSION LINE IN A NONBREAK STATE
};

// CALLBACK FUNCTION TYPES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_NO_SIGNAL_DETECTED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SIGNAL_REMOVED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FORMAT_CHANGED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FORMAT_CHANGED_CALLBACK_EX)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoNativeFrameRate /*IN*/, double dVideoGrabFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_DONE_CALLBACK)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_STREAM_CALLBACK)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_RECORD_DONE_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_RECORD_FAIL_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, QRESULT nErrorStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_DONE_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_FAIL_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, QRESULT nErrorStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK)( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_HARDWARE_ENCODER_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, double dDelayTime /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, double dDelayTime /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.I (EVENT) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( PVOID pDevice /*IN*/, PF_NO_SIGNAL_DETECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( PVOID pDevice /*IN*/, PF_SIGNAL_REMOVED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK_EX pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_DONE_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_FAIL_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_FAIL_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_FAIL_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.II (DATA) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK( PVOID pDevice /*IN*/, PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // VANC

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_VIDEO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_AUDIO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.III (DATA) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.IIII (DATA) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_AUDIO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_MEDIA_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_MEDIA_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VERSION( ULONG * pMajorVersion /*OUT*/, ULONG * pMinorVersion /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_SYSTEM_CONFIGURATION( BOOL   bEnableMultipleUsersAccess = TRUE,					 /*IN*/ // If true, qcap will alllow multiple users to access the device.

															    BOOL   bEnableVideoPreviewDevice = TRUE,					 /*IN*/ // If true, the video capture device will be enabled.

															    BOOL   bEnableAudioPreviewDevice = TRUE,					 /*IN*/ // If true, the audio capture device will be enabled.

															    BOOL   bEnableVideoHardwareMainEncoderDevice = TRUE,		 /*IN*/ // If true, the main hardware encoder will be enabled.

															    BOOL   bEnableVideoHardwareSubEncoderDevice = TRUE,			 /*IN*/ // If true, the sub hardware encoder will be enabled.

															    ULONG  nAutoInputDetectionTimeout = 3000,					 /*IN*/ // The parameter allows you to specify the timeout duration of the auto input detection, default is 3sec.

															    BOOL   bEnableSCF = FALSE,									 /*IN*/ // If true, the SCF file recording function will be turned on.
															   
															    CHAR * pszDB3 = NULL,										 /*IN*/ // The parameter allows you to specify the file path of SQL database.
															   
															    BOOL   bEnableAsyncBackgroundSnapshot = FALSE,				 /*IN*/ // If true, snapshot function will be moved from preview callback into another thread. 
															   
															    BOOL   bEnableEnhancedVideoRenderer = TRUE,					 /*IN*/ // If true, QCAP will enable the DirectShow's Enhanced Video Renderer Filter.
															   
															    BOOL   bEnableSystemTimeCallback = FALSE,					 /*IN*/ // If true, the preview's and encoder's callbacks will return one local system time at dSampleTime.
															   
															    BOOL   bEnableFileRepairFunction = TRUE,					 /*IN*/ // If true, the recording file will own self-repaired ability.
															   
															    BOOL   bEnableNewRTSPLibrary = TRUE,						 /*IN*/ // If true, we will use new rtsp lib to repalce old one after 1.1.0.130.0
																
																CHAR * pszWebServerRootFolderPath = NULL,					 /*IN*/ // The parameter allows you to specify the web server's root folder path.

																CHAR * pszWebServerIP = NULL,								 /*IN*/ // The parameter allows you to specify the web server's ip address.
																
																ULONG  nSystemColorRangeType = QCAP_COLORRANGE_TYPE_FULL,    /*IN*/ // The parameter allows you to specify the system color range setting.
																
																BOOL   bEnableVideoMixingRendererBugPatch = TRUE,            /*IN*/ // If true, QCAP will enable the bug patch for DirectShow's Video Mixing Renderer, but it will delay the device's initialized time.
																
																BOOL   bEnableDirect3DVideoRenderer = FALSE );               /*IN*/ // If true, QCAP will enable the Direct3D's Video Renderer Filter.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_QUERY_ENCODER_TYPE_CAP( ULONG nEncoderType /*IN*/, ULONG nEncoderFormat /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_QUERY_DECODER_TYPE_CAP( ULONG nDecoderType /*IN*/, ULONG nDecoderFormat /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_QUERY_ENCODER_STATUS( ULONG nEncoderType /*IN*/, ULONG * pExistInstances /*OUT*/ );

// DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DEVICE_ENUMERATION( ULONGLONG * * ppVideoDeviceList /*OUT*/, ULONG * pVideoDeviceSize /*OUT*/, ULONGLONG * * ppVideoEncoderDeviceList /*OUT*/, ULONG * pVideoEncoderDeviceSize /*OUT*/, ULONGLONG * * ppAudioDeviceList /*OUT*/, ULONG * pAudioDeviceSize /*OUT*/, ULONGLONG * * ppAudioEncoderDeviceList /*OUT*/, ULONG * pAudioEncoderDeviceSize /*OUT*/, ULONG nDeviceEnumType = QCAP_ENUM_TYPE_DEVICE_NAME /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO( UINT iDevNum /*IN*/, ULONGLONG * pDeviceList /*IN*/, ULONG * pDeviceInfoH /*OUT*/, ULONG * pDeviceInfoL /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE( CHAR * pszDevName /*IN*/, UINT iDevNum /*IN*/, HWND hAttachedWindow /*IN*/, PVOID * ppDevice /*OUT*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

// DEVICE NAME TABLE:
//
// "DC1150 USB" IS FOR PD652, PD652.3D
//
// "QP0204 USB" IS FOR PD5A0
//
// "UB658G USB" IS FOR UB658
//
// "CY3014 USB" IS FOR UB530
//
// "UB3200 USB" IS FOR PD560
//
// "UB3300 USB" IS FOR PD570
//
// "TW6802 PCI" IS FOR SC200, SC300, SC230, SC330
//
// "CX2581 PCI" IS FOR SC310, SC340
//
// "CX2385 PCI" IS FOR SC350
//
// "AH8400 PCI" IS FOR SC290, SC390
//
// "FH8735 PCI" IS FOR SC2A0, SC3A0
//
// "TW5864 PCI" IS FOR SC2B0, SC3B0
//
// "MZ0380 PCI" IS FOR SC3C0
//
// "SA7160 PCI" IS FOR SC500, SC510, TB510
//
// "FH8735 PCI" IS FOR SC580
//
// "TW2809 PCI" IS FOR SC590
//
// "QP0203 PCI" IS FOR SC540, SC5A0
//
// "MZ0380 PCI" IS FOR SC350, SC3C0, SC550, SC560, SC5C0
//
//     "CAMERA" IS FOR GENERAL USB CAMERA
//
//  "SOUNDCARD" IS FOR GENERAL SOUND CARD
//
//    "DESKTOP" IS FOR GENERAL DESKTOP SCREEN GRABBER

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RUN( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RUN_EX( PVOID pDevice /*IN*/, BOOL bStopAfterSignalRemoved = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_QUERY_DEVICE_CAP( PVOID pDevice /*IN*/, DWORD * pDeviceSerialNumber /*OUT*/, CHAR * pszDeviceSystemPath /*OUT*/, BOOL * pHasHardwareMainEncoder /*OUT*/, BOOL * pHasHardwareSubEncoder /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_INPUT( PVOID pDevice /*IN*/, ULONG * pInput /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_INPUT( PVOID pDevice /*IN*/, ULONG nInput /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_INPUT( PVOID pDevice /*IN*/, ULONG * pInput /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_INPUT( PVOID pDevice /*IN*/, ULONG nInput /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_STANDARD( PVOID pDevice /*IN*/, ULONG * pStandard /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_STANDARD( PVOID pDevice /*IN*/, ULONG nStandard /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS( PVOID pDevice /*IN*/, ULONG * pStatus /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT( PVOID pDevice /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT_EX( PVOID pDevice /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pNativeFrameRate /*OUT*/, double * pGrabFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT( PVOID pDevice /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT( PVOID pDevice /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT( PVOID pDevice /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BOOL bIsInterleaved /*IN*/, double dFrameRate /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT( PVOID pDevice /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT( PVOID pDevice /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES( PVOID pDevice /*IN*/, ULONG * pLines /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES( PVOID pDevice /*IN*/, ULONG nLines /*IN*/ ); // 0 = DISABLE

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_DEINTERLACE_TYPE( PVOID pDevice /*IN*/, ULONG * pType /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_DEINTERLACE_TYPE( PVOID pDevice /*IN*/, ULONG nType /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_DEINTERLACE( PVOID pDevice /*IN*/, BOOL * pEnable /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_DEINTERLACE( PVOID pDevice /*IN*/, BOOL bEnable /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_REGION_DISPLAY( PVOID pDevice /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_REGION_DISPLAY( PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_MIRROR( PVOID pDevice /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_MIRROR( PVOID pDevice /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_BRIGHTNESS( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_BRIGHTNESS( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_CONTRAST( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_CONTRAST( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_HUE( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_HUE( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SATURATION( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SATURATION( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARPNESS( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARPNESS( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ /*PHYSICAL VALUE 0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_BRIGHTNESS_EX( PVOID pDevice /*IN*/, ULONG * pPhysicalValue /*OUT*/ /*0 ~ 255*/, ULONG * pDisplayValue /*OUT*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_BRIGHTNESS_EX( PVOID pDevice /*IN*/, ULONG nPhysicalValue /*IN*/ /*0 ~ 255*/, ULONG nDisplayValue /*IN*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_CONTRAST_EX( PVOID pDevice /*IN*/, ULONG * pPhysicalValue /*OUT*/ /*0 ~ 255*/, ULONG * pDisplayValue /*OUT*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_CONTRAST_EX( PVOID pDevice /*IN*/, ULONG nPhysicalValue /*IN*/ /*0 ~ 255*/, ULONG nDisplayValue /*IN*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_HUE_EX( PVOID pDevice /*IN*/, ULONG * pPhysicalValue /*OUT*/ /*0 ~ 255*/, ULONG * pDisplayValue /*OUT*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_HUE_EX( PVOID pDevice /*IN*/, ULONG nPhysicalValue /*IN*/ /*0 ~ 255*/, ULONG nDisplayValue /*IN*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SATURATION_EX( PVOID pDevice /*IN*/, ULONG * pPhysicalValue /*OUT*/ /*0 ~ 255*/, ULONG * pDisplayValue /*OUT*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SATURATION_EX( PVOID pDevice /*IN*/, ULONG nPhysicalValue /*IN*/ /*0 ~ 255*/, ULONG nDisplayValue /*IN*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARPNESS_EX( PVOID pDevice /*IN*/, ULONG * pPhysicalValue /*OUT*/ /*0 ~ 255*/, ULONG * pDisplayValue /*OUT*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARPNESS_EX( PVOID pDevice /*IN*/, ULONG nPhysicalValue /*IN*/ /*0 ~ 255*/, ULONG nDisplayValue /*IN*/ /*0 ~ 255*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX( PVOID pDevice /*IN*/, ULONG * pDownscaleMode /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX( PVOID pDevice /*IN*/, ULONG nDownscaleMode /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pDownscaleMode /*OUT*/, ULONG * pPostSkipFrameRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pPostAvgFrameRate /*OUT*/ /*DEFAULT = 0*/ ); // SKIP = -1 (0xFFFFFFFF)

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nDownscaleMode /*IN*/,  ULONG   nPostSkipFrameRate /*IN*/  /*DEFAULT = 0*/, ULONG   nPostAvgFrameRate /*IN*/  /*DEFAULT = 0*/ ); // SKIP = -1 (0xFFFFFFFF)

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordProfile /*OUT*/, ULONG * pRecordLevel /*OUT*/, ULONG * pRecordEntropy /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/, BOOL * pIsInterleaved /*OUT*/, ULONG * pSlices /*OUT*/, ULONG * pLayers /*OUT*/, ULONG * pSceneCut /*OUT*/, BOOL * pMultiThread /*OUT*/, BOOL * pMBBRC /*OUT*/, BOOL * pExtBRC /*OUT*/, ULONG * pMinQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pMaxQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVMaxRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVBufSize /*OUT*/ /*DEFAULT = 0*/, ULONG * pCBRVariation /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/, ULONG * pDstW /*OUT*/, ULONG * pDstH /*OUT*/, ULONG * pPostSkipFrameRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pPostAvgFrameRate /*OUT*/ /*DEFAULT = 0*/ ); // SKIP = -1 (0xFFFFFFFF)

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordProfile /*IN*/ , ULONG   nRecordLevel /*IN*/ , ULONG   nRecordEntropy /*IN*/ , ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/ , BOOL   bIsInterleaved /*IN*/ , ULONG   nSlices /*IN*/ , ULONG   nLayers /*IN*/ , ULONG   nSceneCut /*IN*/,  BOOL   bMultiThread /*IN*/,  BOOL   bMBBRC /*IN*/,  BOOL   bExtBRC /*IN*/,  ULONG   nMinQP /*IN*/  /*DEFAULT = 0*/, ULONG   nMaxQP /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVMaxRate /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVBufSize /*IN*/  /*DEFAULT = 0*/, ULONG   nCBRVariation /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nCropX /*IN*/,  ULONG   nCropY /*IN*/,  ULONG   nCropW /*IN*/,  ULONG   nCropH /*IN*/,  ULONG   nDstW /*IN*/,  ULONG   nDstH /*IN*/,  ULONG   nPostSkipFrameRate /*IN*/  /*DEFAULT = 0*/, ULONG   nPostAvgFrameRate /*IN*/  /*DEFAULT = 0*/ ); // SKIP = -1 (0xFFFFFFFF)

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG nProperty /*IN*/, ULONG * pValue /*OUT*/ ); // = AMESDK_GET_VIDEOCOMPRESSION_PROPERTY. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG nProperty /*IN*/, ULONG nValue /*IN*/ ); // = AMESDK_SET_VIDEOCOMPRESSION_PROPERTY. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_SOUND_RENDERER( PVOID pDevice /*IN*/, UINT * pSoundNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SOUND_RENDERER( PVOID pDevice /*IN*/, UINT iSoundNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_VOLUME( PVOID pDevice /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_VOLUME( PVOID pDevice /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_DEVICE_CUSTOM_PROPERTY( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, ULONG * pValue /*OUT*/ ); // = AMESDK_GET_CUSTOM_PROPERTY. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_DEVICE_CUSTOM_PROPERTY( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, ULONG nValue /*IN*/ ); // = AMESDK_SET_CUSTOM_PROPERTY. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, BYTE * pValue /*OUT*/, ULONG nBytes /*IN*/ ); // = AMESDK_GET_CUSTOM_PROPERTY_EX. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, BYTE * pValue /*IN*/, ULONG nBytes /*IN*/ ); // = AMESDK_SET_CUSTOM_PROPERTY_EX. PLS CHECK PRODUCT'S EXTRA PROGRAMMING GUIDE.

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DIAGNOSE_VIDEO_STREAM_STATUS( PVOID pDevice /*IN*/, BOOL * pIsStill /*OUT*/, ULONG nStillThreshold = 64 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DIAGNOSE_AUDIO_STREAM_STATUS( PVOID pDevice /*IN*/, double * pVolumeDB_L /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/, double * pVolumeDB_R /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( PVOID pDevice /*IN*/, PF_NO_SIGNAL_DETECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( PVOID pDevice /*IN*/, PF_SIGNAL_REMOVED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK_EX( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK_EX pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK( PVOID pDevice /*IN*/, PF_VIDEO_VERTICAL_ANCILLARY_DATA_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // VANC

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_VIDEO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_AUDIO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// LOCK/UNLOCK FUNCTIONS (FOR LABVIEW 2010/2012 DEVELOPER) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COPY_VIDEO_PREVIEW_BUFFER( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, ULONG nColorSpaceType /*IN*/, VOID * pFrameBuffer /*IN*/, ULONG * pFrameBufferLen /*IN/OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COPY_AUDIO_PREVIEW_BUFFER( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, VOID * pFrameBuffer /*IN*/, ULONG * pFrameBufferLen /*IN/OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_LOCK_VIDEO_PREVIEW_BUFFER( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, VOID * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_LOCK_AUDIO_PREVIEW_BUFFER( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, VOID * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER( PVOID pDevice /*IN*/ );

// SNAPSHOT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_BMP( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_JPG( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_BMP_EX( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_JPG_EX( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_RECORD_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pDownscaleMode /*OUT*/ ); // HARDWARE ENCODER NEED USE QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_RECORD_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nDownscaleMode /*IN*/  ); // HARDWARE ENCODER NEED USE QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_RECORD_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, BOOL * pMultiThread /*OUT*/ /*DEFAULT = TRUE*/, BOOL * pMBBRC /*OUT*/ /*DEFAULT = FALSE*/, BOOL * pExtBRC /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pMinQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pMaxQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVMaxRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVBufSize /*OUT*/ /*DEFAULT = 0*/, ULONG * pCBRVariation /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/, ULONG * pDstW /*OUT*/, ULONG * pDstH /*OUT*/, ULONG * pPostSkipFrameRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pPostAvgFrameRate /*OUT*/ /*DEFAULT = 0*/ ); // HARDWARE ENCODER NEED USE QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_RECORD_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, BOOL   bMultiThread /*IN*/  /*DEFAULT = TRUE*/, BOOL   bMBBRC /*IN*/  /*DEFAULT = FALSE*/, BOOL   bExtBRC /*IN*/  /*DEFAULT = FALSE*/, ULONG   nMinQP /*IN*/  /*DEFAULT = 0*/, ULONG   nMaxQP /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVMaxRate /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVBufSize /*IN*/  /*DEFAULT = 0*/, ULONG   nCBRVariation /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nCropX /*IN*/,  ULONG   nCropY /*IN*/,  ULONG   nCropW /*IN*/,  ULONG   nCropH /*IN*/,  ULONG   nDstW /*IN*/,  ULONG   nDstH /*IN*/,  ULONG   nPostSkipFrameRate /*IN*/  /*DEFAULT = 0*/, ULONG   nPostAvgFrameRate /*IN*/  /*DEFAULT = 0*/ ); // HARDWARE ENCODER NEED USE QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_RECORD_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_RECORD_PROPERTY( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_RECORD_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_RECORD_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_RECORD_DYNAMIC_PROPERTY_EX( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_RECORD_HEADER( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszTitle /*IN*/, CHAR * pszArtist /*IN*/, CHAR * pszComments /*IN*/, CHAR * pszGenre /*IN*/, CHAR * pszComposer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_RECORD_HEADER_W( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, WSTRING pwszTitle /*IN*/, WSTRING pwszArtist /*IN*/, WSTRING pwszComments /*IN*/, WSTRING pwszGenre /*IN*/, WSTRING pwszComposer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_RECORD_DATA_BUFFER( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, BYTE * pDataBuffer /*IN*/, ULONG nDataBufferSize /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_CLONE_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathNameA /*IN*/, CHAR * pszFilePathNameB /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_TIMESHIFT_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID * ppPhysicalFileWriter /*OUT*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_FAILSAFE_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, UINT iLinkRecNum /*IN*/, PVOID pLinkPhysicalFileWriter /*IN*/, double dPreRecordTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESUME_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_PAUSE_RECORD( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_DONE_CALLBACK(  PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_DONE_CALLBACK  pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_FAIL_CALLBACK(  PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_FAIL_CALLBACK  pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_AUDIO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_MEDIA_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

// CLONE FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_CLONE( PVOID pDevice /*IN*/, HWND hAttachedWindow /*IN*/, PVOID * ppCloneDevice /*OUT*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

// OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 511) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MOVE_OSD_OBJECT( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_OSD_TEXT_BOUNDARY( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_OSD_TEXT_BOUNDARY_W( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_TEXT( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_TEXT_W( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_TEXT_EX( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_TEXT_EX_W( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_PICTURE( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_BUFFER( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_BUFFER_EX( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

// MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) //////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_SYNCHRONIZED_RECORD( PVOID * ppSyncRecorder /*IN*/, ULONG nFileArgs /*IN*/, CHAR * pszFilePathName1 /*IN*/, PVOID pDevice1 /*IN*/, UINT iRecNum1 /*IN*/, CHAR * pszFilePathName2 /*IN*/, PVOID pDevice2 /*IN*/, UINT iRecNum2 /*IN*/, ... );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_SYNCHRONIZED_RECORD( PVOID pSyncRecorder /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_SYNCHRONIZED_RECORD( PVOID pSyncRecorder /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_SYNCHRONIZED_RECORD( PVOID pSyncRecorder /*IN*/, BOOL bIsAsync /*IN*/, ULONG nMilliseconds /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESUME_SYNCHRONIZED_RECORD( PVOID pSyncRecorder );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_PAUSE_SYNCHRONIZED_RECORD( PVOID pSyncRecorder );

// SYNCHRONIZED RECORDING EXAMPLE
//
// QCAP_CREATE_SYNCHRONIZED_RECORD( &pSyncRecorder, 4, "SR_CH01.MP4", pDevices[ 0 ], 0, 
//
//								                       "SR_CH02.MP4", pDevices[ 1 ], 0, 
//
//								                       "SR_CH03.MP4", pDevices[ 2 ], 0, 
//
//								                       "SR_CH04.MP4", pDevices[ 3 ], 0 );
//
// QCAP_START_SYNCHRONIZED_RECORD( pSyncRecorder );
// 
// QCAP_STOP_SYNCHRONIZED_RECORD( pSyncRecorder, TRUE, 0 );
// 
// QCAP_DESTROY_SYNCHRONIZED_RECORD( pSyncRecorder );
// 
// CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CAMERA_ENUMERATION( CHAR * * ppszCameraDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CAMERA_ENUMERATION_W( WSTRING * ppwszCameraDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_DEFAULT_CAMERA( CHAR * pszCameraDevName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_CAMERA_COUNT_OF_SUPPORT_OUTPUT_FORMATS( PVOID pDevice /*IN*/, ULONG * pCount /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_CAMERA_SUPPORT_OUTPUT_FORMAT( PVOID pDevice /*IN*/, UINT iFmtNum /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pFrameRate /*OUT*/ );

// CAMERA EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "CAMERA", 0, hWindow, &pDevice, TRUE );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// SOUNCARD FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDCARD_ENUMERATION( CHAR * * ppszSoundCardDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDCARD_ENUMERATION_W( WSTRING * ppwszSoundCardDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_DEFAULT_SOUNDCARD( CHAR * pszMicrophoneDevName /*IN*/, CHAR * pszLineInDevName /*IN*/ );

// SOUNCARD EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "SOUNDCARD", 0, hWindow, &pDevice, TRUE );
// 
// STEP#02 QCAP_SET_AUDIO_INPUT( pDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_SHARE_RECORD_STATUS( UINT iRecNum /*IN*/, BOOL * pIsValid /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, BOOL * pMultiThread /*OUT*/ /*DEFAULT = TRUE*/, BOOL * pMBBRC /*OUT*/ /*DEFAULT = FALSE*/, BOOL * pExtBRC /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pMinQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pMaxQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVMaxRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVBufSize /*OUT*/ /*DEFAULT = 0*/, ULONG * pCBRVariation /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, BOOL   bMultiThread /*IN*/  /*DEFAULT = TRUE*/, BOOL   bMBBRC /*IN*/  /*DEFAULT = FALSE*/, BOOL   bExtBRC /*IN*/  /*DEFAULT = FALSE*/, ULONG   nMinQP /*IN*/  /*DEFAULT = 0*/, ULONG   nMaxQP /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVMaxRate /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVBufSize /*IN*/  /*DEFAULT = 0*/, ULONG   nCBRVariation /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_DYNAMIC_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_COPP( UINT iRecNum /*IN*/, BOOL * pEnable /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_COPP( UINT iRecNum /*IN*/, BOOL   bEnable /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_BRIGHTNESS( UINT iRecNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_BRIGHTNESS( UINT iRecNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_CONTRAST( UINT iRecNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_CONTRAST( UINT iRecNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_HUE( UINT iRecNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_HUE( UINT iRecNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_SHARE_RECORD_SATURATION( UINT iRecNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_SATURATION( UINT iRecNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_SHARE_RECORD_SOUND_RENDERER( UINT iRecNum /*IN*/, UINT * pSoundNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_SOUND_RENDERER( UINT iRecNum /*IN*/, UINT   iSoundNum /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_SHARE_RECORD_VOLUME( UINT iRecNum /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_VOLUME( UINT iRecNum /*IN*/, ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( UINT iRecNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG bIsKeyFrame /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER( UINT iRecNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_SHARE_RECORD_HEADER( UINT iRecNum /*IN*/, CHAR * pszTitle /*IN*/, CHAR * pszArtist /*IN*/, CHAR * pszComments /*IN*/, CHAR * pszGenre /*IN*/, CHAR * pszComposer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_SHARE_RECORD_HEADER_W( UINT iRecNum /*IN*/, WSTRING pwszTitle /*IN*/, WSTRING pwszArtist /*IN*/, WSTRING pwszComments /*IN*/, WSTRING pwszGenre /*IN*/, WSTRING pwszComposer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_METADATA_SHARE_RECORD_DATA_BUFFER( UINT iRecNum /*IN*/, BYTE * pDataBuffer /*IN*/, ULONG nDataBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_TIMESHIFT_SHARE_RECORD( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID * ppPhysicalFileWriter /*OUT*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_SHARE_RECORD( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_SHARE_RECORD( UINT iRecNum /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESUME_SHARE_RECORD( UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_PAUSE_SHARE_RECORD( UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_SHARE_RECORD_BMP( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_SHARE_RECORD_JPG( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MOVE_OSD_SHARE_RECORD_OBJECT( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY_W( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_TEXT( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_TEXT_W( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_TEXT_EX( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_TEXT_EX_W( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_PICTURE( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_BUFFER( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_OSD_SHARE_RECORD_BUFFER_EX( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_FAIL_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_FAIL_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_MEDIA_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_DISPLAY_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DISPLAY_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// VIDEO 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) ///////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ );

// AUDIO MIXING/TRACKS SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 63) (TRACKNUM: 0 ~ 3) //////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG * pTracks /*OUT*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX( UINT iRecNum /*IN*/, ULONG   nTracks /*IN*/,  ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, UINT iMixNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER_EX( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, UINT iMixNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # BROADCASTING SERVER FUNCTIONS (RTSP/RTMP/HLS/TS/MMS) (2D/3D)
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*OUT*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, double dDelayTime /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, double dDelayTime /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_BROADCAST_SERVER_STATUS( UINT iSvrNum /*IN*/ /*0 ~ 63*/, BOOL * pIsValid /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |2D|3D|  |*/ QCAP_CREATE_BROADCAST_RTSP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTSP = 554 /*IN*/, ULONG nNetworkPort_RTSPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, BOOL bEnableMulticasting = FALSE /*IN*/, BOOL bEnableUltraLowLatency = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |2D|3D|  |*/ QCAP_CREATE_BROADCAST_RTSP_RAW_UDP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTSP = 554 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |HLS|  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_HLS_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszWebServerRootFolderPath /*IN*/, CHAR * pszSubFolderPath /*IN*/, ULONG nSegmentDuration = 1000 /*IN*/, BOOL bResumeSegmentNum = FALSE /*IN*/, ULONG nSegmentPlaylistCount = 3 /*IN*/, CHAR * pszWebServerIP = NULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |RTMP|   |  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_RTMP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTMP = 1935 /*IN*/, ULONG nNetworkPort_RTMPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, CHAR * pszServerName = NULL /*IN*/ /*DEFAULT = "flvplayback"*/, CHAR * pszMediaFolderPath = NULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |RTMP|   |  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_RTMP_SERVER_EX( UINT iSvrNum /*IN*/ /*0 ~ 63*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTMP = 1935 /*IN*/, ULONG nNetworkPort_RTMPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, CHAR * pszServerName = NULL /*IN*/ /*DEFAULT = "flvplayback"*/, CHAR * pszMediaFolderPath = NULL /*IN*/, CHAR * pszEncryptKey = NULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |RTMP|   |  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |RTMP|   |  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, CHAR * pszEncryptKey = NULL /*IN*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |  |MMS|2D|  |  |*/ QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |TS|   |2D|  |  |*/ QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, ULONG nServiceID = 1 /*IN*/, CHAR * pszServiceName = NULL /*IN*/, CHAR * pszServiceProviderName = NULL /*IN*/, BOOL bEnableCBRMode = TRUE /*IN*/, ULONG nTransferBitRate = 0 /*IN*/ /*0 = FREE*/, ULONG nOriginalNetworkID = 1 /*IN*/, ULONG nTransportStreamID = 1 /*IN*/, ULONG nPMT_PID = 4096 /*IN*/, ULONG nPCR_PID = 4097 /*IN*/, ULONG nVideo_PID = 256 /*IN*/, ULONG nAudio_PID = 257 /*IN*/, ULONG nVideo_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nAudio_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nPCRInterval = 0 /*IN*/ /*ms*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |TS|   |2D|  |  |*/ QCAP_CREATE_BROADCAST_TS_OVER_TCP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, PVOID * ppServer /*OUT*/, ULONG nNetworkPort_TCP = 1234 /*IN*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, ULONG nServiceID = 1 /*IN*/, CHAR * pszServiceName = NULL /*IN*/, CHAR * pszServiceProviderName = NULL /*IN*/, ULONG nTransferBitRate = 0 /*IN*/ /*0 = FREE*/, ULONG nOriginalNetworkID = 1 /*IN*/, ULONG nTransportStreamID = 1 /*IN*/, ULONG nPMT_PID = 4096 /*IN*/, ULONG nPCR_PID = 4097 /*IN*/, ULONG nVideo_PID = 256 /*IN*/, ULONG nAudio_PID = 257 /*IN*/, ULONG nVideo_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nAudio_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nPCRInterval = 0 /*IN*/ /*ms*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |TS|   |2D|  |  |*/ QCAP_CREATE_BROADCAST_TS_OVER_HTTP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, PVOID * ppServer /*OUT*/, ULONG nNetworkPort_HTTP = 8888 /*IN*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, ULONG nServiceID = 1 /*IN*/, CHAR * pszServiceName = NULL /*IN*/, CHAR * pszServiceProviderName = NULL /*IN*/, ULONG nTransferBitRate = 0 /*IN*/ /*0 = FREE*/, ULONG nOriginalNetworkID = 1 /*IN*/, ULONG nTransportStreamID = 1 /*IN*/, ULONG nPMT_PID = 4096 /*IN*/, ULONG nPCR_PID = 4097 /*IN*/, ULONG nVideo_PID = 256 /*IN*/, ULONG nAudio_PID = 257 /*IN*/, ULONG nVideo_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nAudio_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nPCRInterval = 0 /*IN*/ /*ms*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |TS|   |2D|  |  |*/ QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, ULONG nServiceID = 1 /*IN*/, CHAR * pszServiceName = NULL /*IN*/, CHAR * pszServiceProviderName = NULL /*IN*/, BOOL bEnableCBRMode = TRUE /*IN*/, ULONG nTransferBitRate = 0 /*IN*/ /*0 = FREE*/, ULONG nOriginalNetworkID = 1 /*IN*/, ULONG nTransportStreamID = 1 /*IN*/, ULONG nPMT_PID = 4096 /*IN*/, ULONG nPCR_PID = 4097 /*IN*/, ULONG nVideo_PID = 256 /*IN*/, ULONG nAudio_PID = 257 /*IN*/, ULONG nVideo_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nAudio_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nPCRInterval = 0 /*IN*/ /*ms*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |TS|   |2D|  |  |*/ QCAP_CREATE_BROADCAST_TS_OVER_TCP_PASSIVE_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, ULONG nServiceID = 1 /*IN*/, CHAR * pszServiceName = NULL /*IN*/, CHAR * pszServiceProviderName = NULL /*IN*/, ULONG nTransferBitRate = 0 /*IN*/ /*0 = FREE*/, ULONG nOriginalNetworkID = 1 /*IN*/, ULONG nTransportStreamID = 1 /*IN*/, ULONG nPMT_PID = 4096 /*IN*/, ULONG nPCR_PID = 4097 /*IN*/, ULONG nVideo_PID = 256 /*IN*/, ULONG nAudio_PID = 257 /*IN*/, ULONG nVideo_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nAudio_CodecID = 0 /*IN*/ /*0 = AUTO*/, ULONG nPCRInterval = 0 /*IN*/ /*ms*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |   |  |   |2D|  |  |*/ QCAP_CREATE_BROADCAST_NDI_SERVER( UINT iSvrNum /*IN*/ /*0 ~ 63*/, CHAR * pszNDIName /*IN*/, CHAR * pszGroups /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszConnectionMetadata  = NULL /*IN*/ ); // TOTOAL SESSION = 1

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_DESTROY_BROADCAST_SERVER( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_START_BROADCAST_SERVER( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_STOP_BROADCAST_SERVER( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|  |  |*/ QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PVOID pDevice /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|  |  |*/ QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * * ppszSessionName /*OUT*/, ULONG * pVideoDelayLiveDuration /*OUT*/ /*ms*/, ULONG * pAudioDelayLiveDuration /*OUT*/ /*ms*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszSessionName /*IN*/ /*DEFAULT = "session%d.mpg"*/, ULONG nVideoDelayLiveDuration /*IN*/ /*ms*/, ULONG nAudioDelayLiveDuration /*IN*/ /*ms*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/, DWORD * pFlags = NULL /*OUT*/                    );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/, DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, BOOL * pMultiThread /*OUT*/ /*DEFAULT = TRUE*/, BOOL * pMBBRC /*OUT*/ /*DEFAULT = FALSE*/, BOOL * pExtBRC /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pMinQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pMaxQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVMaxRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVBufSize /*OUT*/ /*DEFAULT = 0*/, ULONG * pCBRVariation /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/, DWORD * pFlags = NULL /*OUT*/                    );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, BOOL   bMultiThread /*IN*/  /*DEFAULT = TRUE*/, BOOL   bMBBRC /*IN*/  /*DEFAULT = FALSE*/, BOOL   bExtBRC /*IN*/  /*DEFAULT = FALSE*/, ULONG   nMinQP /*IN*/  /*DEFAULT = 0*/, ULONG   nMaxQP /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVMaxRate /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVBufSize /*IN*/  /*DEFAULT = 0*/, ULONG   nCBRVariation /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/, DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_DYNAMIC_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_GET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pTracks /*OUT*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_SET_AUDIO_MX_BROADCAST_SERVER_PROPERTY_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nTracks /*IN*/,  ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT * pSoundNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_SOUND_RENDERER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT   iSoundNum /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_AUDIO_BROADCAST_SERVER_VOLUME( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_VOLUME( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_VIDEO_BROADCAST_SERVER_NETWORK_QOS_STATUS( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BOOL * pIsTransferBusy /*OUT*/, ULONG * pQueueFrames /*OUT*/, ULONG * pQueueBytes /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_AUDIO_BROADCAST_SERVER_NETWORK_QOS_STATUS( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BOOL * pIsTransferBusy /*OUT*/, ULONG * pQueueFrames /*OUT*/, ULONG * pQueueBytes /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG bIsKeyFrame /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |  |3D|  |*/ QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, UINT iMixNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, UINT iMixNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_SET_AUDIO_MX_BROADCAST_SERVER_COMPRESSION_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_CLEAR_VIDEO_BROADCAST_SERVER_DELAY_LIVE_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BOOL bEnableClear /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG bIsKeyFrame /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_CLEAR_AUDIO_BROADCAST_SERVER_DELAY_LIVE_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BOOL bEnableClear /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_CLEAR_AUDIO_MX_BROADCAST_SERVER_DELAY_LIVE_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iTrackNum /*IN*/, BOOL bEnableClear /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SNAPSHOT_BROADCAST_SERVER_BMP( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SNAPSHOT_BROADCAST_SERVER_JPG( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_MOVE_OSD_BROADCAST_SERVER_OBJECT( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY_W( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_TEXT( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_TEXT_W( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_TEXT_EX_W( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_PICTURE( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_BUFFER( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_SET_OSD_BROADCAST_SERVER_BUFFER_EX( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |2D|3D|  |*/ QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |   |  |   |2D|3D|  |*/ QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_REGISTER_AUDIO_MX_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_MX_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|MX|*/ QCAP_REGISTER_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_DECODER_MX_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|HLS|TS|MMS|2D|3D|  |*/ QCAP_REGISTER_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_BROADCAST_SERVER_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// BROADCASTING RTSP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "root", "root", 554 );
//
//         CH01 URL -> rtsp://root:root@127.0.0.1:554/session0.mpg
//
//         CH02 URL -> rtsp://root:root@127.0.0.1:554/session1.mpg
//
//         CH03 URL -> rtsp://root:root@127.0.0.1:554/session2.mpg
//
//         CH04 URL -> rtsp://root:root@127.0.0.1:554/session3.mpg
// 
// STEP#02 QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
// STEP#03 QCAP_START_BROADCAST_SERVER( pServer );
//
// STEP#04 QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferD, nFrameBufferLenD );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, pFrameBufferD, nFrameBufferLenD );
//
// STEP#05 QCAP_STOP_BROADCAST_SERVER( pServer );
//
// STEP#06 QCAP_DRSTROY_BROADCAST_SERVER( pServer );

// BROADCASTING RTMP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, NULL, NULL, 1935 );
//
//         CH01 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session0.mpg (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session1.mpg
//
//         CH03 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session2.mpg
//
//         CH04 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session3.mpg

// BROADCASTING HLS SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "C:\\AppServ\\www\\", "hls\\", 3000 ); // HERE, C:\\AppServ\\www\\ IS YOUR WEB SERVER ROOT FOLDER, hls\\ is SUB FOLDER TO SAVE HLS FILES
//
//         CH01 URL -> http://xxx.xxx.xxx.xxx/hls/session0.m3u8 (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> http://xxx.xxx.xxx.xxx/hls/session1.m3u8
//
//         CH03 URL -> http://xxx.xxx.xxx.xxx/hls/session2.m3u8
//
//         CH04 URL -> http://xxx.xxx.xxx.xxx/hls/session3.m3u8

// BROADCASTING UDP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER( 0, "udp://xxx.xxx.xxx.xxx:xxx", &pServer );

// ##########################################################################################################################################################################################
// #
// # BROADCASTING CLIENT FUNCTIONS (RTSP/RTMP/TS) (2D/3D)
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK)( PVOID pClient /*IN*/, ULONG nTotalStreams /*IN*/, UINT iStreamNum /*IN*/, ULONG nStream_PID /*IN*/, ULONG nProgram_PID /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_FAIL_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, QRESULT nErrorStatus /*IN*/, DWORD nErrorCode /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, QRESULT nErrorStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iChNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|  |*/ QCAP_CREATE_BROADCAST_CLIENT( UINT iCliNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE /*IN*/, HWND hAttachedWindow = NULL /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|  |*/ QCAP_CREATE_BROADCAST_CLIENT_EX( UINT iCliNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE /*IN*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, HWND hAttachedWindow = NULL /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |  |    |  |3D|*/ QCAP_CREATE_3D_BROADCAST_CLIENT( UINT iCliNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE /*IN*/, HWND hAttachedWindowL = NULL /*IN*/, BOOL bThumbDrawL = FALSE /*IN*/, BOOL bMaintainAspectRatioL = FALSE /*IN*/, HWND hAttachedWindowR = NULL /*IN*/, BOOL bThumbDrawR = FALSE /*IN*/, BOOL bMaintainAspectRatioR = FALSE /*IN*/ ); // ONLY FOR RTSP

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |  |    |  |3D|*/ QCAP_CREATE_3D_BROADCAST_CLIENT_EX( UINT iCliNum /*IN*/ /*0 ~ 63*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE /*IN*/, CHAR * pszNetworkAdapterIP = NULL /*IN*/, HWND hAttachedWindowL = NULL /*IN*/, BOOL bThumbDrawL = FALSE /*IN*/, BOOL bMaintainAspectRatioL = FALSE /*IN*/, HWND hAttachedWindowR = NULL /*IN*/, BOOL bThumbDrawR = FALSE /*IN*/, BOOL bMaintainAspectRatioR = FALSE /*IN*/ ); // ONLY FOR RTSP

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_DESTROY_BROADCAST_CLIENT( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_START_BROADCAST_CLIENT( PVOID pClient /*IN*/, ULONG nProtocol = QCAP_BROADCAST_PROTOCOL_TCP /*IN*/ /*FOR RTSP ONLY*/, ULONG nReconnectionTimeout = 3000 /*IN*/ /*ms*/, ULONG nDelayQueueDuration = 0 /*IN*/ /*ms*/ ); // BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_START_BROADCAST_CLIENT_EX( PVOID pClient /*IN*/, ULONG nProtocol = QCAP_BROADCAST_PROTOCOL_TCP /*IN*/ /*FOR RTSP ONLY*/, ULONG nReconnectionTimeout = 3000 /*IN*/ /*ms*/, ULONG nDelayQueueDuration = 0 /*IN*/ /*ms*/, BOOL bEnableUltraLowLatency = FALSE /*FOR RTSP ONLY*/, ULONG nAnalyzeDuration = 0 /*FOR TS ONLY, MPTS = 10000*/ /*ms*/, ULONG nProbeDurationSizeKB = 0 /*FOR TS ONLY, MPTS = 100000 KB*/, CHAR * pszEncryptKey = NULL /*FOR RTMP ONLY*/ ); // BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_STOP_BROADCAST_CLIENT( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |TS|MPTS|2D|  |*/ QCAP_GET_BROADCAST_CLIENT_OUTPUT_STREAMS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pVideoStream_PID /*OUT*/, ULONG * pAudioStream_PID /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|    |    |TS|MPTS|2D|  |*/ QCAP_SET_BROADCAST_CLIENT_OUTPUT_STREAMS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nVideoStream_PID /*IN*/, ULONG nAudioStream_PID /*IN*/, HWND hAttachedWindow = NULL /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_DIAGNOSE_VIDEO_BROADCAST_CLIENT_STREAM_STATUS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL * pIsStill /*OUT*/, ULONG nStillThreshold = 64 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_DIAGNOSE_AUDIO_BROADCAST_CLIENT_STREAM_STATUS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, double * pVolumeDB_L /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/, double * pVolumeDB_R /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |  |    |  |3D|*/ QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pStereoDisplayMode /*OUT*/, BOOL * pLeftRightSwap /*OUT*/ ); 

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |  |    |  |3D|*/ QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ ); 

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pType /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE_TYPE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nType /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_DEINTERLACE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL * pEnable /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_DEINTERLACE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL bEnable /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_BRIGHTNESS( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_CONTRAST( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_CONTRAST( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_HUE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_HUE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_VIDEO_BROADCAST_CLIENT_SATURATION( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_VIDEO_BROADCAST_CLIENT_SATURATION( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT * pSoundNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_AUDIO_BROADCAST_CLIENT_SOUND_RENDERER( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iSoundNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_START_BROADCAST_CLIENT_TIMESHIFT_RECORD( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID * ppPhysicalFileWriter /*OUT*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_START_BROADCAST_CLIENT_RECORD( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_STOP_BROADCAST_CLIENT_RECORD( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_RESUME_BROADCAST_CLIENT_RECORD( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_PAUSE_BROADCAST_CLIENT_RECORD( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_MOVE_OSD_BROADCAST_CLIENT_OBJECT( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY_W( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_TEXT( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_W( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_TEXT_EX_W( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER_EX( PVOID pClient /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * * ppszValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_MEDIAINFO_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_MEDIAINFO_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_CONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_FAIL_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_FAIL_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_RECORD_FAIL_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_AUDIO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|RTMP|TS|MPTS|2D|3D|*/ QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|RTSP|    |  |    |  |3D|*/ QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// BROADCASTING CLIENT EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_CLIENT( 0, "rtsp://root:root@127.0.0.1:554/session0.mpg", &pClient, QCAP_DECODER_TYPE_SOFTWARE, hWindow, TRUE );
//
// STEP#02 QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_video_stream, this );
//
//         QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_audio_stream, this );
//
// STEP#03 QCAP_START_BROADCAST_CLIENT( pClient );
//
// STEP#04 QCAP_STOP_BROADCAST_CLIENT( pClient );
//
// STEP#05 QCAP_DESTROY_BROADCAST_CLIENT( pClient );

// ##########################################################################################################################################################################################
// #
// # ONVIF COMMUNICATION FUNCTIONS (SERVER/EMULATOR/CLIENT)
// #
// ##########################################################################################################################################################################################
//
// COMMUNICATION SERVER FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*OUT*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, ULONG nEncoderFormat /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, ULONG nFrameRate /*IN*/, ULONG nRecordMode /*IN*/, ULONG nQuality /*IN*/, ULONG nBitRate /*IN*/, ULONG nGOP /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, ULONG nEncoderFormat /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, ULONG nBitRate /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_COMMUNICATION_ONVIF_SERVER( ULONG nTotalVideoSources /*IN*/, ULONG nTotalAudioSources /*IN*/, ULONG nTotalVideoEncoders /*IN*/, ULONG nTotalAudioEncoders /*IN*/, ULONG nTotalProfiles /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszName = NULL /*IN*/, CHAR * pszLocation = NULL /*IN*/, CHAR * pszManufacturer = NULL /*IN*/, CHAR * pszModel = NULL /*IN*/, CHAR * pszHardwareVersion = NULL /*IN*/, CHAR * pszFirmwareVersion = NULL /*IN*/, CHAR * pszDeviceID = NULL /*IN*/, CHAR * pszRootAccount = NULL /*IN*/, CHAR * pszRootPassword = NULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_COMMUNICATION_SERVER( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_COMMUNICATION_SERVER( PVOID pServer /*IN*/, ULONG nNetworkPort = 8001 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_COMMUNICATION_SERVER( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE( PVOID pServer /*IN*/, UINT iVidSrcNum /*IN*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE( PVOID pServer /*IN*/, UINT iVidSrcNum /*IN*/, ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  ULONG   nFrameRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE( PVOID pServer /*IN*/, UINT iAudSrcNum /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE( PVOID pServer /*IN*/, UINT iAudSrcNum /*IN*/, ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER( PVOID pServer /*IN*/, UINT iVidEncNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pFrameRate_Min /*OUT*/, ULONG * pFrameRate_Max /*OUT*/, ULONG * pFrameRate_Default /*OUT*/, ULONG * pRecordMode_Min /*OUT*/, ULONG * pRecordMode_Max /*OUT*/, ULONG * pRecordMode_Default /*OUT*/, ULONG * pQuality_Min /*OUT*/, ULONG * pQuality_Max /*OUT*/, ULONG * pQuality_Default /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/, ULONG * pGOP_Min /*OUT*/, ULONG * pGOP_Max /*OUT*/, ULONG * pGOP_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER( PVOID pServer /*IN*/, UINT iVidEncNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  ULONG   nFrameRate_Min /*IN*/,  ULONG   nFrameRate_Max /*IN*/,  ULONG   nFrameRate_Default /*IN*/,  ULONG   nRecordMode_Min /*IN*/,  ULONG   nRecordMode_Max /*IN*/,  ULONG   nRecordMode_Default /*IN*/,  ULONG   nQuality_Min /*IN*/,  ULONG   nQuality_Max /*IN*/,  ULONG   nQuality_Default /*IN*/,  ULONG   nBitRate_Min /*IN*/,  ULONG   nBitRate_Max /*IN*/,  ULONG   nBitRate_Default /*IN*/,  ULONG   nGOP_Min /*IN*/,  ULONG   nGOP_Max /*IN*/,  ULONG   nGOP_Default /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER( PVOID pServer /*IN*/, UINT iAudEncNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER( PVOID pServer /*IN*/, UINT iAudEncNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate_Min /*IN*/,  ULONG   nBitRate_Max /*IN*/,  ULONG   nBitRate_Default /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_SERVER_PROFILE( PVOID pServer /*IN*/, UINT iProNum /*IN*/, CHAR * * ppszURL /*OUT*/, UINT * pVidSrcNum /*OUT*/, UINT * pAudSrcNum /*OUT*/, UINT * pVidEncNum /*OUT*/, UINT * pAudEncNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_SERVER_PROFILE( PVOID pServer /*IN*/, UINT iProNum /*IN*/, CHAR *   pszURL /*IN*/,   UINT   iVidSrcNum /*IN*/,  UINT   iAudSrcNum /*IN*/,  UINT   iVidEncNum /*IN*/,  UINT   iAudEncNum /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// COMMUNICATION EMULATOR FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK)( PVOID pEmulator /*IN*/, ULONG nTotalServers /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR( PVOID * ppEmulator /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_COMMUNICATION_EMULATOR( PVOID pEmulator /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_COMMUNICATION_EMULATOR( PVOID pEmulator /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_COMMUNICATION_EMULATOR( PVOID pEmulator /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO( PVOID pEmulator /*IN*/, UINT iSvrNum /*IN*/, CHAR * * ppszNetworkIP /*OUT*/, ULONG * pNetworkPort /*OUT*/, CHAR * * ppszNetworkURL /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK( PVOID pEmulator /*IN*/, PF_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// COMMUNICATION CLIENT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK)( PVOID pClient /*IN*/, ULONG nTotalVideoSources /*IN*/, ULONG nTotalAudioSources /*IN*/, ULONG nTotalVideoEncoders /*IN*/, ULONG nTotalAudioEncoders /*IN*/, ULONG nTotalProfiles /*IN*/, CHAR * pszName /*IN*/, CHAR * pszLocationr /*IN*/, CHAR * pszManufacturer /*IN*/, CHAR * pszModel /*IN*/, CHAR * pszHardwareVersion /*IN*/, CHAR * pszFirmwareVersion /*IN*/, CHAR * pszDeviceID /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_COMMUNICATION_ONVIF_CLIENT( CHAR * pszNetworkURL /*IN*/, PVOID * ppClient /*OUT*/, CHAR * pszAccount = NULL /*IN*/ /*DEFAULT = "root"*/, CHAR * pszPassword = NULL /*IN*/ /*DEFAULT = "root"*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_COMMUNICATION_CLIENT( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_COMMUNICATION_CLIENT( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_COMMUNICATION_CLIENT( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_VIDEO_SOURCE_INFO( PVOID pClient /*IN*/, UINT iVidSrcNum /*IN*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_AUDIO_SOURCE_INFO( PVOID pClient /*IN*/, UINT iAudSrcNum /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_INFO( PVOID pClient /*IN*/, UINT iVidEncNum /*IN*/, ULONG * pTotalVidEncOptions /*OUT*/, UINT * pVidEncOptionNum_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_INFO( PVOID pClient /*IN*/, UINT iAudEncNum /*IN*/, ULONG * pTotalAudEncOptions /*OUT*/, UINT * pAudEncOptionNum_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_VIDEO_ENCODER_OPTION_INFO( PVOID pClient /*IN*/, UINT iVidEncNum /*IN*/, UINT iVidEncOptionNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pWidthList /*OUT*/, ULONG * pWidthListSize /*OUT*/, ULONG * pWidth_Default /*OUT*/, ULONG * pHeightList /*OUT*/, ULONG * pHeightListSize /*OUT*/, ULONG * pHeight_Default /*OUT*/, ULONG * pFrameRate_Min /*OUT*/, ULONG * pFrameRate_Max /*OUT*/, ULONG * pFrameRate_Default /*OUT*/, ULONG * pRecordMode_Min /*OUT*/, ULONG * pRecordMode_Max /*OUT*/, ULONG * pRecordMode_Default /*OUT*/, ULONG * pQuality_Min /*OUT*/, ULONG * pQuality_Max /*OUT*/, ULONG * pQuality_Default /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/, ULONG * pGOP_Min /*OUT*/, ULONG * pGOP_Max /*OUT*/, ULONG * pGOP_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_AUDIO_ENCODER_OPTION_INFO( PVOID pClient /*IN*/, UINT iAudEncNum /*IN*/, UINT iAudEncOptionNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannelsList /*OUT*/, ULONG * pChannelsListSize /*OUT*/, ULONG * pChannels_Default /*OUT*/, ULONG * pBitsPerSampleList /*OUT*/, ULONG * pBitsPerSampleListSize /*OUT*/, ULONG * pBitsPerSample_Default /*OUT*/, ULONG * pSampleFrequencyList /*OUT*/, ULONG * pSampleFrequencyListSize /*OUT*/, ULONG * pSampleFrequency_Default /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_PROFILE_INFO( PVOID pClient /*IN*/, UINT iProNum /*IN*/, CHAR * * ppszURL /*OUT*/, UINT * pVidSrcNum /*OUT*/, UINT * pAudSrcNum /*OUT*/, UINT * pVidEncNum /*OUT*/, UINT * pAudEncNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY( PVOID pClient /*IN*/, UINT iProNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_CLIENT_PROFILE_VIDEO_PROPERTY( PVOID pClient /*IN*/, UINT iProNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  ULONG   nFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY( PVOID pClient /*IN*/, UINT iProNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_CLIENT_PROFILE_AUDIO_PROPERTY( PVOID pClient /*IN*/, UINT iProNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * * ppszValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_COMMUNICATION_CLIENT_CUSTOM_PROPERTY( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_CLIENT_CONNECTED_CALLBACK( PVOID pClient /*IN*/, PF_COMMUNICATION_CLIENT_CONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # WEBRTC FUNCTIONS (CHATROOM)
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_WEBRTC_CHATROOM( ULONG nNetworkPort /*IN*/, PVOID * ppChatRoom /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_WEBRTC_CHATROOM( PVOID pChatRoom /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # WEBRTC FUNCTIONS (P2P)
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGIN_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszPeerUserName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszType /*IN*/, CHAR * pszSDP /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_CONNECTED_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, QRESULT nConnectionStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_WEBRTC_PEER_DISCONNECTED_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_DATA_DONE_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, QRESULT nSendStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_SEND_FILE_DONE_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, QRESULT nSendStatus /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszData /*IN*/, ULONG nDataSize /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszFileNamePath /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK)( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, ULONG nRecvSize /*IN*/, ULONG nTotalSize /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN(QCAP_EXPORT *PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK)( PVOID pChatter /*IN*/, ULONG nExpectedBitRate /*IN*/, ULONG nExpectedFrameRate /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_WEBRTC_CHATTER( CHAR * pszChatRoomLoginIP /*IN*/, ULONG nChatRoomLoginPort /*IN*/, CHAR * pszUserName /*IN*/, PVOID * ppChatter /*OUT*/, ULONG  * pLoginID /*OUT*/, ULONG nConnectionTimeout = 5000 /*IN*/, CHAR * pszStunURL = NULL /*IN*/, CHAR * pszReceivedFileFolderPath = NULL /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_WEBRTC_CHATTER( PVOID pChatter /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_WEBRTC_CHAT( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_WEBRTC_CHAT( PVOID pChatter /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_WEBRTC_SENDER( PVOID pChatter /*IN*/, UINT iSvrNum /*IN*/ /*0 ~ 63*/, PVOID * ppServer /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_WEBRTC_RECEIVER( PVOID pChatter /*IN*/, UINT iCliNum /*IN*/ /*0 ~ 63*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType = QCAP_DECODER_TYPE_SOFTWARE /*IN*/, HWND hAttachedWindow = NULL /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_WEBRTC_PRIVATE_SDP_PROPERTY( PVOID pChatter /*IN*/, ULONG nPeerID /*IN*/, CHAR * pszSDP /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( PVOID pChatter /*IN*/, ULONG * pPeerID /*OUT*/, CHAR * * ppszPeerUserName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SEND_WEBRTC_DATA( PVOID pChatter /*IN*/, CHAR * pszData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SEND_WEBRTC_FILE( PVOID pChatter /*IN*/, CHAR * pszFilePathName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_CHATROOM_LOGIN_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_CHATROOM_LOGIN_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_CHATROOM_LOGOUT_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_CHATROOM_LOGOUT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_PRIVATE_SDP_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PEER_CONNECTED_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_PEER_CONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_PEER_DISCONNECTED_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_PEER_DISCONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_SEND_DATA_DONE_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_SEND_DATA_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_SEND_FILE_DONE_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_SEND_FILE_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_DATA_DONE_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_RECEIVED_DATA_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_FILE_DONE_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_RECEIVED_FILE_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_RECEIVED_FILE_STATUS_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_WEBRTC_NETWORK_QOS_STATUS_CALLBACK( PVOID pChatter /*IN*/, PF_WEBRTC_NETWORK_QOS_STATUS_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # FILE PLAYBACK FUNCTIONS (PLAYBACK/EDITING/REPAIR/FILE)
// #
// ##########################################################################################################################################################################################
//
// FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK_EX)( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK_EX)( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile /*IN*/, UINT iChNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|   |  |  |   |*/ QCAP_OPEN_FILE( CHAR * pszFileName /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/, BOOL bEnableEditFunction = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |2D+|  |  |   |*/ QCAP_OPEN_FILE_EX( CHAR * pszFileName /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ ); // MP4 ONLY, NOW

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |3D|  |   |*/ QCAP_OPEN_3D_FILE( CHAR * pszFileName /*IN*/, PVOID * ppFile /*OUT*/, BOOL * pIs3D /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/, HWND hAttachedWindowL /*IN*/, BOOL bThumbDrawL = FALSE /*IN*/, BOOL bMaintainAspectRatioL = FALSE /*IN*/, HWND hAttachedWindowR = NULL /*IN*/, BOOL bThumbDrawR = FALSE /*IN*/, BOOL bMaintainAspectRatioR = FALSE /*IN*/, BOOL bEnableEditFunction = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |TS|   |*/ QCAP_OPEN_TIMESHIFT_FILE_EX( PVOID pPhysicalFileWriter /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_OPEN_SCF_FILE( UINT iChNum /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/, double dStartSampleTime = 0.0 /*IN*/, double dStopSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_DESTROY_FILE( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_PLAY_FILE( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_PAUSE_FILE( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_STOP_FILE( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_PLAY_GLOBAL_SCF_FILE();

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_PAUSE_GLOBAL_SCF_FILE();

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_STOP_GLOBAL_SCF_FILE();

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |TS|   |*/ QCAP_REFRESH_TIMESHIFT_FILE_INFO( PVOID pFile /*IN*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/ ); // QCAP_OPEN_TIMESHIFT_FILE_EX

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_SCF_FILE_ENUMERATION( UINT iChNum /*IN*/, double dStartSearchTime /*IN*/, double dStopSearchTime /*IN*/, ULONG * pFileSizeHigh /*OUT*/, ULONG * pFileSizeLow /*OUT*/, double * pFileStartTime /*OUT*/, double * pFileStopTime /*OUT*/, double * pVideoStartTime /*OUT*/, double * pVideoStopTime /*OUT*/, double * pAudioStartTime /*OUT*/, double * pAudioStopTime /*OUT*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_SET_SCF_FILE_TIMER( UINT iChNum /*IN*/, BOOL bEnableGlobalTimer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_FILE_POSITION( PVOID pFile /*IN*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_FILE_POSITION( PVOID pFile /*IN*/, double dSampleTime /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |2D+|  |TS|   |*/ QCAP_GET_FILE_POSITION_EX( PVOID pFile /*IN*/, double * pSampleTime /*OUT*/, ULONG nTimeUnit = QCAP_FILE_TIMEUNIT_FRAME /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |2D+|  |TS|   |*/ QCAP_SET_FILE_POSITION_EX( PVOID pFile /*IN*/, double dSampleTime /*IN*/, ULONG nTimeUnit = QCAP_FILE_TIMEUNIT_FRAME /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_GET_GLOBAL_SCF_FILE_POSITION( double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |  |  |SCF|*/ QCAP_SET_GLOBAL_SCF_FILE_POSITION( double dSampleTime /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_FILE_PLAYBACK_SPEED( PVOID pFile /*IN*/, double * pSpeed /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_FILE_PLAYBACK_SPEED( PVOID pFile /*IN*/, double dSpeed /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_STREAM_BUFFER( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, BYTE * pStreamBuffer /*OUT*/, ULONG * pStreamBufferLen /*IN/OUT*/, BOOL * pIsKeyFrame /*OUT*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_AUDIO_FILE_STREAM_BUFFER( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, BYTE * pStreamBuffer /*OUT*/, ULONG * pStreamBufferLen /*IN/OUT*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_METADATA_FILE_DATA_BUFFER( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, BYTE * pDataBuffer /*OUT*/, ULONG * pDataBufferLen /*IN/OUT*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_METADATA_FILE_HEADER( PVOID pFile /*IN*/, CHAR * * ppszTitle /*OUT*/, CHAR * * ppszArtist /*OUT*/, CHAR * * ppszComments /*OUT*/, CHAR * * ppszGenre /*OUT*/, CHAR * * ppszComposer /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_METADATA_FILE_HEADER_W( PVOID pFile /*IN*/, WSTRING * ppwszTitle /*OUT*/, WSTRING * ppwszArtist /*OUT*/, WSTRING * ppwszComments /*OUT*/, WSTRING * ppwszGenre /*OUT*/, WSTRING * ppwszComposer /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |3D|  |   |*/ QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE( PVOID pFile /*IN*/, ULONG * pStereoDisplayMode /*OUT*/, BOOL * pLeftRightSwap /*OUT*/ );  // ONLY FOR QCAP_OPEN_3D_FILE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |3D|  |   |*/ QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE( PVOID pFile /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ ); // ONLY FOR QCAP_OPEN_3D_FILE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_REGION_DISPLAY( PVOID pFile /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_REGION_DISPLAY( PVOID pFile /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_MIRROR( PVOID pFile /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_MIRROR( PVOID pFile /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_BRIGHTNESS( PVOID pFile /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_BRIGHTNESS( PVOID pFile /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_CONTRAST( PVOID pFile /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_CONTRAST( PVOID pFile /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_HUE( PVOID pFile /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_HUE( PVOID pFile /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_VIDEO_FILE_SATURATION( PVOID pFile /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_VIDEO_FILE_SATURATION( PVOID pFile /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_AUDIO_FILE_SOUND_RENDERER( PVOID pFile /*IN*/, UINT * pSoundNum /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_AUDIO_FILE_SOUND_RENDERER( PVOID pFile /*IN*/, UINT iSoundNum /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_AUDIO_FILE_VOLUME( PVOID pFile /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_AUDIO_FILE_VOLUME( PVOID pFile /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SNAPSHOT_FILE_BMP( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SNAPSHOT_FILE_JPG( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SNAPSHOT_FILE_BMP_EX( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SNAPSHOT_FILE_JPG_EX( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_MOVE_OSD_FILE_OBJECT( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_OSD_FILE_TEXT_BOUNDARY( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_GET_OSD_FILE_TEXT_BOUNDARY_W( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_TEXT( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_TEXT_W( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_TEXT_EX( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_TEXT_EX_W( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_PICTURE( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_BUFFER( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_SET_OSD_FILE_BUFFER_EX( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( PVOID pFile /*IN*/, PF_VIDEO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|2D|2D+|3D|TS|SCF|*/ QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( PVOID pFile /*IN*/, PF_AUDIO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |2D+|  |TS|   |*/ QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX( PVOID pFile /*IN*/, PF_VIDEO_DECODER_FILE_CALLBACK_EX pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |2D+|  |TS|   |*/ QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX( PVOID pFile /*IN*/, PF_AUDIO_DECODER_FILE_CALLBACK_EX pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR QCAP_OPEN_FILE_EX & QCAP_OPEN_TIMESHIFT_FILE_EX

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |   |3D|  |   |*/ QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK( PVOID pFile /*IN*/, PF_VIDEO_DECODER_3D_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR QCAP_OPEN_3D_FILE

// FILE EDITING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_EXPORT_FILE( PVOID pFile /*IN*/, double dStartSampleTime /*IN*/, double dStopSampleTime /*IN*/, CHAR * pszExportedFileName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_EXPORT_FILE_EX( PVOID pFile /*IN*/, CHAR * pszExportedFileName /*IN*/, ULONG nFileArgs /*IN*/, double dStartSampleTime1 /*IN*/, double dStopSampleTime1 /*IN*/, double dStartSampleTime2 /*IN*/, double dStopSampleTime2 /*IN*/, ... );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_EXPORT_FILE_EX_C( PVOID pFile /*IN*/, CHAR * pszExportedFileName /*IN*/, ULONG nFileArgs /*IN*/, double dStartSampleTimes[ ] /*IN*/, double dStopSampleTimes[ ] /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_EXPORT_FILES_EX( PVOID pFile /*IN*/, ULONG nFileArgs /*IN*/, double dStartSampleTime1 /*IN*/, double dStopSampleTime1 /*IN*/, CHAR * pszExportedFileName1 /*IN*/, double dStartSampleTime2 /*IN*/, double dStopSampleTime2 /*IN*/, CHAR * pszExportedFileName2 /*IN*/, ... );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_EXPORT_FILES_EX_C( PVOID pFile /*IN*/, ULONG nFileArgs /*IN*/, double dStartSampleTimes[ ] /*IN*/, double dStopSampleTimes[ ] /*IN*/, CHAR * pszExportedFileNames[ ] /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MERGE_FILES( CHAR * pszFrontEndFileName /*IN*/, CHAR * pszBackEndFileName /*IN*/, CHAR * pszMergedFileName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MERGE_FILES_EX( CHAR * pszMergedFileName /*IN*/, ULONG nFileArgs /*IN*/, CHAR * pszSourceFileName1 /*IN*/, CHAR * pszSourceFileName2 /*IN*/, ... );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MERGE_FILES_EX_C( CHAR * pszMergedFileName /*IN*/, ULONG nFileArgs /*IN*/, CHAR * pszSourceFileNames[ ] /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_MERGE_FILES_BY_EDL( CHAR * pszEDLFileName /*IN*/ ); // PLEASE REFERENCE DOC\MANUALS\13. FILE\MERGE.EDL.EXAMPLE.INI

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_BUILD_VIDEO_ON_DEMAND_FILE( CHAR * pszOriginalFileName /*IN*/, CHAR * pszVideoOnDemandFileName /*IN*/ ); // ONLY FOR MP4 FILE BOXING

// FILE REPAIR FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DIAGNOSE_FILE( CHAR * pszFileName /*IN*/, BOOL * pIsHealthy /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REPAIR_FILE( CHAR * pszBadFileName /*IN*/, CHAR * pszRepairedFileName /*IN*/ );

// FILE TRANSCODING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
typedef QRETURN (QCAP_EXPORT *PF_FILE_TRANSCODER_CALLBACK)( PVOID pFileTranscoder /*IN*/, double dPercentageCompleted /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_FILE_TRANSCODER( CHAR * pszSrcFileName /*IN*/, PVOID * ppFileTranscoder /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, ULONG * pTotalMetadataFrames /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_FILE_TRANSCODER( PVOID pFileTranscoder /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY( PVOID pFileTranscoder /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY( PVOID pFileTranscoder /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_VIDEO_FILE_TRANSCODER_PROPERTY_EX( PVOID pFileTranscoder /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, BOOL * pMultiThread /*OUT*/ /*DEFAULT = TRUE*/, BOOL * pMBBRC /*OUT*/ /*DEFAULT = FALSE*/, BOOL * pExtBRC /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pMinQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pMaxQP /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVMaxRate /*OUT*/ /*DEFAULT = 0*/, ULONG * pVBVBufSize /*OUT*/ /*DEFAULT = 0*/, ULONG * pCBRVariation /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_VIDEO_FILE_TRANSCODER_PROPERTY_EX( PVOID pFileTranscoder /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, BOOL   bMultiThread /*IN*/  /*DEFAULT = TRUE*/, BOOL   bMBBRC /*IN*/  /*DEFAULT = FALSE*/, BOOL   bExtBRC /*IN*/  /*DEFAULT = FALSE*/, ULONG   nMinQP /*IN*/  /*DEFAULT = 0*/, ULONG   nMaxQP /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVMaxRate /*IN*/  /*DEFAULT = 0*/, ULONG   nVBVBufSize /*IN*/  /*DEFAULT = 0*/, ULONG   nCBRVariation /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_FILE_TRANSCODER( PVOID pFileTranscoder /*IN*/, CHAR * pszDstFileName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_FILE_TRANSCODER( PVOID pFileTranscoder /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FILE_TRANSCODER_CALLBACK( PVOID pFileTranscoder /*IN*/, PF_FILE_TRANSCODER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # ANIMATION FUNCTIONS
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_ANIMATION_CLIP( CHAR * pszAniFileName /*IN*/, PVOID * ppClip /*OUT*/, ULONG * pTotalFrames /*OUT*/, ULONG * pTotalSprites /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_ANIMATION_CLIP( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_ANIMATION_CLIP( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_ANIMATION_CLIP( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STEP_ANIMATION_CLIP( PVOID pClip /*IN*/, UINT * pFrameNum /*OUT*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SEEK_ANIMATION_CLIP( PVOID pClip /*IN*/, UINT iFrameNum /*IN*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, INT * pPositionX /*OUT*/, INT * pPositionY /*OUT*/, INT * pScaleW /*OUT*/, INT * pScaleH /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, INT nPositionX /*IN*/, INT nPositionY /*IN*/, INT nScaleW /*IN*/, INT nScaleH /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, double * pAlpha /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, double nAlpha /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, CHAR * pszFilePathName /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, PVOID pDevice /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

// ANIMATION EXAMPLE:
//
// STEP#01 QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.FADEOUT.XML", &pClip, &nFrames, &nSprites, &nColorSpaceType, &nWidth, &nHeight );
//
// STEP#02 QCAP_START_ANIMATION_CLIP( pClip );
//
// STEP#03 QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
// 
//         QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
// STEP#04 QCAP_STEP_ANIMATION_CLIP( pClip, &iFrameNum, &pFrameBuffer, &nFrameBufferLen, TRUE );
//
// STEP#05 QCAP_STOP_ANIMATION_CLIP( pClip );
//
// STEP#06 QCAP_DESTROY_ANIMATION_CLIP( pClip );

// ##########################################################################################################################################################################################
// #
// # VIRTUAL CAMERA FUNCTIONS
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_CREATE_VIRTUAL_CAMERA( UINT iCamNum /*IN*/ /*0 ~ 63*/, PVOID * ppCamera /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_DESTROY_VIRTUAL_CAMERA( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY( PVOID pCamera /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY( PVOID pCamera /*IN*/, ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY( PVOID pCamera /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY( PVOID pCamera /*IN*/, ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/  );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( PVOID pCamera /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX( PVOID pCamera /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nScaleStyle = QCAP_SCALE_STYLE_STRETCH /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( PVOID pCamera /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX( PVOID pCamera /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|MX|*/ QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER( PVOID pCamera /*IN*/, UINT iMixNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ ); // ONLY FOR AUDIO MIXING

QCAP_EXT_API QRESULT QCAP_EXPORT /*|MX|*/ QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER_EX( PVOID pCamera /*IN*/, UINT iMixNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ ); // ONLY FOR AUDIO MIXING

QCAP_EXT_API QRESULT QCAP_EXPORT /*|MX|*/ QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( PVOID pCamera /*IN*/, double dSampleTime = 0.0 /*IN*/ ); // ONLY FOR AUDIO MIXING

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_START_VIRTUAL_CAMERA( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_STOP_VIRTUAL_CAMERA( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_MOVE_OSD_VIRTUAL_CAMERA_OBJECT( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ ); // FOR SCROLLING TEXT/PICTURE

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY_W( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_W( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT_EX_W( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, WSTRING pwszString /*IN*/, WSTRING pwszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nStringAlignmentStyle = QCAP_STRING_ALIGNMENT_STYLE_LEFT /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER_EX( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, DWORD dwBorderColor /*IN*/, ULONG nBorderWidth /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, double dLifeTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT /*|  |*/ QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # SERIAL PORT I/O FUNCTIONS (RS232/RS485)
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK)( PVOID pPort /*IN*/, UINT iPortNum /*IN*/, BYTE * pDataBuffer /*IN*/, ULONG nDataBufferLen /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SERIAL_PORT_ENUMERATION( UINT * pAvailablePortNum /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_SERIAL_PORT( UINT iPortNum /*IN*/, PVOID * ppPort /*OUT*/, ULONG nBaudRate = 9600 /*IN*/, ULONG nDataBits = 8 /*IN*/, ULONG nParityCheck = QCAP_SERIAL_PORT_PARITY_CHECK_NONE /*IN*/, ULONG nStopBits = QCAP_SERIAL_PORT_STOP_BITS_ONE /*IN*/, ULONG nFlowControl = QCAP_SERIAL_PORT_FLOW_CONTROL_NONE /*IN*/, BOOL bAsynchronousIO = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_SERIAL_PORT( PVOID pPort /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_SERIAL_PORT( PVOID pPort /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_SERIAL_PORT( PVOID pPort /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SEND_SERIAL_PORT_SIGNAL( PVOID pPort /*IN*/, ULONG nSignalType /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SEND_SERIAL_PORT_DATA( PVOID pPort /*IN*/, BYTE * pDataBuffer /*IN*/, ULONG nDataBufferLen /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SERIAL_PORT_RECEIVED_DATA_CALLBACK( PVOID pPort /*IN*/, PF_SERIAL_PORT_RECEIVED_DATA_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # DISC BURNING FUNCTIONS
// #
// ##########################################################################################################################################################################################
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_BURNING_DRIVE( CHAR cDriveName /*IN*/, CHAR * pVolumeName /*IN*/, PVOID * ppDrive /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_BURNING_DRIVE( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_BURNING_DRIVE( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_BURNING_DRIVE( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_UNLOAD_DISC( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_LOAD_DISC( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_DISC_INFO( PVOID pDrive /*IN*/, BOOL * pIsDiscBlank /*OUT*/, BOOL * pIsDiscWriteable /*OUT*/, DWORD * pDiscType /*OUT*/, ULONGLONG * pDiscRemainCapability /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_ERASE_DISC( PVOID pDrive /*IN*/ );

// BURNING EXAMPLE:
// 
// STEP#01 QCAP_CREATE_BURNING_DRIVE( 'E', "TEST", &pDrive );
//
// STEP#02 QCAP_START_BURNING_DRIVE( pDrive );
// 
// STEP#03 QCAP_START_RECORD( pDevice, 0, "E:\\CH01.TS" );
// 
// STEP#04 QCAP_STOP_RECORD( pDevice, 0, FALSE, INFINE ); // NOTE!! WAITIING FILE CLOSE
// 
// STEP#05 QCAP_STOP_BURNING_DRIVE( pDrive );
// 
// STEP#06 QCAP_UNLOAD_DISC( pDrive );
// 
// STEP#07 QCAP_DESTROY_BURNING_DRIVE( pDrive );

// ##########################################################################################################################################################################################
// #
// # MEDIA TIMER FUNCTIONS (HIGH PRECISION)
// #
// ##########################################################################################################################################################################################
//
typedef QRETURN (QCAP_EXPORT *PF_MEDIA_TIMER_CALLBACK)( PVOID pTimer /*IN*/, double dSampleTime /*IN*/, double dDelayTime /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CREATE_MEDIA_TIMER( ULONG nElapseTimeNum /*IN*/, ULONG nElapseTimeDeno /*IN*/, PVOID * ppTimer /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_DESTROY_MEDIA_TIMER( PVOID pTimer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_START_MEDIA_TIMER( PVOID pTimer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_STOP_MEDIA_TIMER( PVOID pTimer /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_TIMER_CALLBACK( PVOID pTimer /*IN*/, PF_MEDIA_TIMER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # HELPER FUNCTIONS (ENCODER/VIDEO/AUDIO/DEVELOPER)
// #
// ##########################################################################################################################################################################################
//
// HELPER FUNCTIONS PART.1 (FOR ENCODER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_H264_BUFFER_LAYER_ID( BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG * pLayerID /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_H264_BUFFER_COLOR_INFO( BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG * pColorRangeType /*OUT*/ );

// HELPER FUNCTIONS PART.2 (FOR VIDEO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YUY2_TO_ABGR32( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YV12_TO_ABGR32( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YUY2_TO_ARGB32( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YV12_TO_ARGB32( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YUY2_TO_BGR24(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YV12_TO_BGR24(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YUY2_TO_RGB24(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YV12_TO_RGB24(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YUY2_TO_YV12(   BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_COLORSPACE_YV12_TO_YUY2(   BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_BUFFER_TO_BMP_EX( CHAR * pszFilePathName /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, UINT nCropX /*IN*/, UINT nCropY /*IN*/, UINT nCropW /*IN*/, UINT nCropH /*IN*/, UINT nDstW /*IN*/, UINT nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/, BYTE * pszDstStreamBuffer = NULL /*OUT*/, ULONG * pDstStreamBufferSize = NULL /*IN/OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SNAPSHOT_BUFFER_TO_JPG_EX( CHAR * pszFilePathName /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, UINT nCropX /*IN*/, UINT nCropY /*IN*/, UINT nCropW /*IN*/, UINT nCropH /*IN*/, UINT nDstW /*IN*/, UINT nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/, BYTE * pszDstStreamBuffer = NULL /*OUT*/, ULONG * pDstStreamBufferSize = NULL /*IN/OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CONVERT_3D_STEREO_BUFFER( ULONG nColorSpaceType /*IN*/, ULONG nSrcStereoDisplayMode /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, ULONG nDstStereoDisplayMode /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESIZE_VIDEO_BUFFER( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESIZE_VIDEO_BUFFER_TO_QDEEP_32F( ULONG nSrcColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, float * pDstFrameBuffer_R /*OUT*/, float * pDstFrameBuffer_G /*OUT*/, float * pDstFrameBuffer_B /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY( ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG * pDstWidth /*OUT*/, ULONG * pDstHeight /*OUT*/, double dAngle /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_ROTATE_VIDEO_BUFFER( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, double dAngle /*IN*/, BYTE * pSrcTempFrameBuffer = NULL /*IN*/, BYTE * pDstTempFrameBuffer = NULL /*IN*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_WARP_VIDEO_BUFFER( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, LONG nWarpDstX1 /*IN*/, LONG nWarpDstY1 /*IN*/, LONG nWarpDstX2 /*IN*/, LONG nWarpDstY2 /*IN*/, LONG nWarpDstX3 /*IN*/, LONG nWarpDstY3 /*IN*/, LONG nWarpDstX4 /*IN*/, LONG nWarpDstY4 /*IN*/, BYTE * pSrcTempFrameBuffer = NULL /*IN*/, BYTE * pDstTempFrameBuffer = NULL /*IN*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_LOAD_PICTURE_BUFFER( CHAR * pszFilePathName /*IN*/, ULONG * pColorSpaceType /*OUT*/, BYTE * pFrameBuffer /*OUT*/, ULONG * pFrameBufferSize /*IN/OUT*/, ULONG * pFrameWidth /*OUT*/, ULONG * pFrameHeight /*OUT*/, ULONG * pFramePitch /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_CALCULATE_CHROMAKEY( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, ULONG nSrcCropX /*IN*/, ULONG nSrcCropY /*IN*/, ULONG nSrcCropW /*IN*/, ULONG nSrcCropH /*IN*/, BYTE * pDstAlpahBuffer /*OUT*/, BYTE * pDstYBuffer /*OUT*/, BYTE * pDstCbBuffer /*OUT*/, BYTE * pDstCrBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/ /*0xFFFFFFFF (OFF) / 0x00FF0000 (BLUE) / 0x0000FF00 (GREEN)*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, ULONG nKeyColorBlurLevel = 2 /*IN*/ /*0 ~ 2*/, BOOL bKeyColorSpillSuppress = TRUE /*IN*/, ULONG nKeyColorSpillSuppressThreshold = 22 /*IN*/ );

// HELPER FUNCTIONS PART.3 (FOR AUDIO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_BUFFER_VOLUME_DB( BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, UINT iChNum /*IN*/, double * pVolumeDB /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_GET_AUDIO_BUFFER_FAST_FOURIER_TRANSFORM_DATA( BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, UINT iChNum /*IN*/, double * pPeakFrq /*OUT*/, double * pPeakFrqAmp /*OUT*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESAMPLE_AUDIO_BUFFER( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcFrameBufferLen /*IN*/, ULONG nSrcChannels /*IN*/, ULONG nSrcBitsPerSample /*IN*/, ULONG nSrcSampleFrequency /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG * pDstFrameBufferLen /*IN/OUT*/, ULONG nDstChannels /*IN*/, ULONG nDstBitsPerSample /*IN*/, ULONG nDstSampleFrequency /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_RESCALE_AUDIO_BUFFER( BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDRENDERER_ENUMERATION( CHAR * * ppszSoundRendererDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_SOUNDRENDERER_ENUMERATION_W( WSTRING * ppwszSoundRendererDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

// HELPER FUNCTIONS PART.4 (FOR .NET DEVELOPER) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API ULONGLONG QCAP_EXPORT QCAP_HELPER_OBJPTR( PVOID pObj /*IN*/ );

#endif // QCAP_H

